/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.Ac3Settings;

public class Ac3SettingsUnmarshaller
implements Unmarshaller<Ac3Settings, JsonUnmarshallerContext> {
    private static final Ac3SettingsUnmarshaller INSTANCE = new Ac3SettingsUnmarshaller();

    public Ac3Settings unmarshall(JsonUnmarshallerContext context) throws Exception {
        Ac3Settings.Builder ac3SettingsBuilder = Ac3Settings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bitrate", targetDepth)) {
                    context.nextToken();
                    ac3SettingsBuilder.bitrate((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("bitstreamMode", targetDepth)) {
                    context.nextToken();
                    ac3SettingsBuilder.bitstreamMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("codingMode", targetDepth)) {
                    context.nextToken();
                    ac3SettingsBuilder.codingMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("dialnorm", targetDepth)) {
                    context.nextToken();
                    ac3SettingsBuilder.dialnorm((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("drcProfile", targetDepth)) {
                    context.nextToken();
                    ac3SettingsBuilder.drcProfile((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("lfeFilter", targetDepth)) {
                    context.nextToken();
                    ac3SettingsBuilder.lfeFilter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("metadataControl", targetDepth)) {
                    context.nextToken();
                    ac3SettingsBuilder.metadataControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Ac3Settings)ac3SettingsBuilder.build();
    }

    public static Ac3SettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

