/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.AacSettings;

@SdkInternalApi
public class AacSettingsMarshaller {
    private static final MarshallingInfo<Double> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").build();
    private static final MarshallingInfo<String> INPUTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputType").build();
    private static final MarshallingInfo<String> PROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("profile").build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").build();
    private static final MarshallingInfo<String> RAWFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rawFormat").build();
    private static final MarshallingInfo<Double> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final MarshallingInfo<String> SPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spec").build();
    private static final MarshallingInfo<String> VBRQUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vbrQuality").build();
    private static final AacSettingsMarshaller INSTANCE = new AacSettingsMarshaller();

    public static AacSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AacSettings aacSettings, ProtocolMarshaller protocolMarshaller) {
        if (aacSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)aacSettings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.codingModeString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.inputTypeString(), INPUTTYPE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.profileString(), PROFILE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.rateControlModeString(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.rawFormatString(), RAWFORMAT_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.sampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.specString(), SPEC_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.vbrQualityString(), VBRQUALITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

