/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.Input;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;

public final class ListInputsPaginator
implements SdkIterable<ListInputsResponse> {
    private final MediaLiveClient client;
    private final ListInputsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInputsPaginator(MediaLiveClient client, ListInputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInputsResponseFetcher();
    }

    public Iterator<ListInputsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Input> inputs() {
        Function<ListInputsResponse, Iterator> getIterator = response -> response != null ? response.inputs().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInputsResponseFetcher
    implements NextPageFetcher<ListInputsResponse> {
        private ListInputsResponseFetcher() {
        }

        public boolean hasNextPage(ListInputsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListInputsResponse nextPage(ListInputsResponse previousPage) {
            if (previousPage == null) {
                return ListInputsPaginator.this.client.listInputs(ListInputsPaginator.this.firstRequest);
            }
            return ListInputsPaginator.this.client.listInputs((ListInputsRequest)((Object)ListInputsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

