/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.InputSecurityGroup;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;

public final class ListInputSecurityGroupsPaginator
implements SdkIterable<ListInputSecurityGroupsResponse> {
    private final MediaLiveClient client;
    private final ListInputSecurityGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInputSecurityGroupsPaginator(MediaLiveClient client, ListInputSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInputSecurityGroupsResponseFetcher();
    }

    public Iterator<ListInputSecurityGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<InputSecurityGroup> inputSecurityGroups() {
        Function<ListInputSecurityGroupsResponse, Iterator> getIterator = response -> response != null ? response.inputSecurityGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInputSecurityGroupsResponseFetcher
    implements NextPageFetcher<ListInputSecurityGroupsResponse> {
        private ListInputSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInputSecurityGroupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListInputSecurityGroupsResponse nextPage(ListInputSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInputSecurityGroupsPaginator.this.client.listInputSecurityGroups(ListInputSecurityGroupsPaginator.this.firstRequest);
            }
            return ListInputSecurityGroupsPaginator.this.client.listInputSecurityGroups((ListInputSecurityGroupsRequest)((Object)ListInputSecurityGroupsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

