/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.VideoSelectorPid;
import software.amazon.awssdk.services.medialive.model.VideoSelectorProgramId;
import software.amazon.awssdk.services.medialive.transform.VideoSelectorSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VideoSelectorSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, VideoSelectorSettings> {
    private final VideoSelectorPid videoSelectorPid;
    private final VideoSelectorProgramId videoSelectorProgramId;

    private VideoSelectorSettings(BuilderImpl builder) {
        this.videoSelectorPid = builder.videoSelectorPid;
        this.videoSelectorProgramId = builder.videoSelectorProgramId;
    }

    public VideoSelectorPid videoSelectorPid() {
        return this.videoSelectorPid;
    }

    public VideoSelectorProgramId videoSelectorProgramId() {
        return this.videoSelectorProgramId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSelectorPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSelectorProgramId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelectorSettings)) {
            return false;
        }
        VideoSelectorSettings other = (VideoSelectorSettings)obj;
        return Objects.equals(this.videoSelectorPid(), other.videoSelectorPid()) && Objects.equals(this.videoSelectorProgramId(), other.videoSelectorProgramId());
    }

    public String toString() {
        return ToString.builder((String)"VideoSelectorSettings").add("VideoSelectorPid", (Object)this.videoSelectorPid()).add("VideoSelectorProgramId", (Object)this.videoSelectorProgramId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VideoSelectorPid": {
                return Optional.of(clazz.cast(this.videoSelectorPid()));
            }
            case "VideoSelectorProgramId": {
                return Optional.of(clazz.cast(this.videoSelectorProgramId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoSelectorSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private VideoSelectorPid videoSelectorPid;
        private VideoSelectorProgramId videoSelectorProgramId;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelectorSettings model) {
            this.videoSelectorPid(model.videoSelectorPid);
            this.videoSelectorProgramId(model.videoSelectorProgramId);
        }

        public final VideoSelectorPid.Builder getVideoSelectorPid() {
            return this.videoSelectorPid != null ? this.videoSelectorPid.toBuilder() : null;
        }

        @Override
        public final Builder videoSelectorPid(VideoSelectorPid videoSelectorPid) {
            this.videoSelectorPid = videoSelectorPid;
            return this;
        }

        public final void setVideoSelectorPid(VideoSelectorPid.BuilderImpl videoSelectorPid) {
            this.videoSelectorPid = videoSelectorPid != null ? videoSelectorPid.build() : null;
        }

        public final VideoSelectorProgramId.Builder getVideoSelectorProgramId() {
            return this.videoSelectorProgramId != null ? this.videoSelectorProgramId.toBuilder() : null;
        }

        @Override
        public final Builder videoSelectorProgramId(VideoSelectorProgramId videoSelectorProgramId) {
            this.videoSelectorProgramId = videoSelectorProgramId;
            return this;
        }

        public final void setVideoSelectorProgramId(VideoSelectorProgramId.BuilderImpl videoSelectorProgramId) {
            this.videoSelectorProgramId = videoSelectorProgramId != null ? videoSelectorProgramId.build() : null;
        }

        public VideoSelectorSettings build() {
            return new VideoSelectorSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VideoSelectorSettings> {
        public Builder videoSelectorPid(VideoSelectorPid var1);

        default public Builder videoSelectorPid(Consumer<VideoSelectorPid.Builder> videoSelectorPid) {
            return this.videoSelectorPid((VideoSelectorPid)((VideoSelectorPid.Builder)VideoSelectorPid.builder().apply(videoSelectorPid)).build());
        }

        public Builder videoSelectorProgramId(VideoSelectorProgramId var1);

        default public Builder videoSelectorProgramId(Consumer<VideoSelectorProgramId.Builder> videoSelectorProgramId) {
            return this.videoSelectorProgramId((VideoSelectorProgramId)((VideoSelectorProgramId.Builder)VideoSelectorProgramId.builder().apply(videoSelectorProgramId)).build());
        }
    }
}

