/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace;
import software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceUsage;
import software.amazon.awssdk.services.medialive.model.VideoSelectorSettings;
import software.amazon.awssdk.services.medialive.transform.VideoSelectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VideoSelector
implements StructuredPojo,
ToCopyableBuilder<Builder, VideoSelector> {
    private final String colorSpace;
    private final String colorSpaceUsage;
    private final VideoSelectorSettings selectorSettings;

    private VideoSelector(BuilderImpl builder) {
        this.colorSpace = builder.colorSpace;
        this.colorSpaceUsage = builder.colorSpaceUsage;
        this.selectorSettings = builder.selectorSettings;
    }

    public VideoSelectorColorSpace colorSpace() {
        return VideoSelectorColorSpace.fromValue(this.colorSpace);
    }

    public String colorSpaceString() {
        return this.colorSpace;
    }

    public VideoSelectorColorSpaceUsage colorSpaceUsage() {
        return VideoSelectorColorSpaceUsage.fromValue(this.colorSpaceUsage);
    }

    public String colorSpaceUsageString() {
        return this.colorSpaceUsage;
    }

    public VideoSelectorSettings selectorSettings() {
        return this.selectorSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceUsageString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector)obj;
        return Objects.equals(this.colorSpaceString(), other.colorSpaceString()) && Objects.equals(this.colorSpaceUsageString(), other.colorSpaceUsageString()) && Objects.equals(this.selectorSettings(), other.selectorSettings());
    }

    public String toString() {
        return ToString.builder((String)"VideoSelector").add("ColorSpace", (Object)this.colorSpaceString()).add("ColorSpaceUsage", (Object)this.colorSpaceUsageString()).add("SelectorSettings", (Object)this.selectorSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColorSpace": {
                return Optional.of(clazz.cast(this.colorSpaceString()));
            }
            case "ColorSpaceUsage": {
                return Optional.of(clazz.cast(this.colorSpaceUsageString()));
            }
            case "SelectorSettings": {
                return Optional.of(clazz.cast(this.selectorSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String colorSpace;
        private String colorSpaceUsage;
        private VideoSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelector model) {
            this.colorSpace(model.colorSpace);
            this.colorSpaceUsage(model.colorSpaceUsage);
            this.selectorSettings(model.selectorSettings);
        }

        public final String getColorSpace() {
            return this.colorSpace;
        }

        @Override
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        public final Builder colorSpace(VideoSelectorColorSpace colorSpace) {
            this.colorSpace(colorSpace.toString());
            return this;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        public final String getColorSpaceUsage() {
            return this.colorSpaceUsage;
        }

        @Override
        public final Builder colorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
            return this;
        }

        @Override
        public final Builder colorSpaceUsage(VideoSelectorColorSpaceUsage colorSpaceUsage) {
            this.colorSpaceUsage(colorSpaceUsage.toString());
            return this;
        }

        public final void setColorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
        }

        public final VideoSelectorSettings.Builder getSelectorSettings() {
            return this.selectorSettings != null ? this.selectorSettings.toBuilder() : null;
        }

        @Override
        public final Builder selectorSettings(VideoSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        public final void setSelectorSettings(VideoSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        public VideoSelector build() {
            return new VideoSelector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VideoSelector> {
        public Builder colorSpace(String var1);

        public Builder colorSpace(VideoSelectorColorSpace var1);

        public Builder colorSpaceUsage(String var1);

        public Builder colorSpaceUsage(VideoSelectorColorSpaceUsage var1);

        public Builder selectorSettings(VideoSelectorSettings var1);

        default public Builder selectorSettings(Consumer<VideoSelectorSettings.Builder> selectorSettings) {
            return this.selectorSettings((VideoSelectorSettings)((VideoSelectorSettings.Builder)VideoSelectorSettings.builder().apply(selectorSettings)).build());
        }
    }
}

