/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.medialive.model.ListOfValidationErrorCopier;
import software.amazon.awssdk.services.medialive.model.MediaLiveException;
import software.amazon.awssdk.services.medialive.model.ValidationError;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnprocessableEntityException
extends MediaLiveException
implements ToCopyableBuilder<Builder, UnprocessableEntityException> {
    private final List<ValidationError> validationErrors;

    private UnprocessableEntityException(BuilderImpl builder) {
        super(builder.message);
        this.validationErrors = builder.validationErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<ValidationError> validationErrors() {
        return this.validationErrors;
    }

    static final class BuilderImpl
    implements Builder {
        private List<ValidationError> validationErrors;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessableEntityException model) {
            this.validationErrors(model.validationErrors);
            this.message = model.getMessage();
        }

        public final Collection<ValidationError.Builder> getValidationErrors() {
            return this.validationErrors != null ? (Collection)this.validationErrors.stream().map(ValidationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ListOfValidationErrorCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError ... validationErrors) {
            this.validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @JsonProperty(value="validationErrors")
        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ListOfValidationErrorCopier.copyFromBuilder(validationErrors);
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public UnprocessableEntityException build() {
            return new UnprocessableEntityException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnprocessableEntityException> {
        public Builder validationErrors(Collection<ValidationError> var1);

        public Builder validationErrors(ValidationError ... var1);

        public Builder message(String var1);
    }
}

