/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputLossActionForUdpOut;
import software.amazon.awssdk.services.medialive.model.UdpTimedMetadataId3Frame;
import software.amazon.awssdk.services.medialive.transform.UdpGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UdpGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, UdpGroupSettings> {
    private final String inputLossAction;
    private final String timedMetadataId3Frame;
    private final Integer timedMetadataId3Period;

    private UdpGroupSettings(BuilderImpl builder) {
        this.inputLossAction = builder.inputLossAction;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
    }

    public InputLossActionForUdpOut inputLossAction() {
        return InputLossActionForUdpOut.fromValue(this.inputLossAction);
    }

    public String inputLossActionString() {
        return this.inputLossAction;
    }

    public UdpTimedMetadataId3Frame timedMetadataId3Frame() {
        return UdpTimedMetadataId3Frame.fromValue(this.timedMetadataId3Frame);
    }

    public String timedMetadataId3FrameString() {
        return this.timedMetadataId3Frame;
    }

    public Integer timedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossActionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3FrameString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3Period());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UdpGroupSettings)) {
            return false;
        }
        UdpGroupSettings other = (UdpGroupSettings)obj;
        return Objects.equals(this.inputLossActionString(), other.inputLossActionString()) && Objects.equals(this.timedMetadataId3FrameString(), other.timedMetadataId3FrameString()) && Objects.equals(this.timedMetadataId3Period(), other.timedMetadataId3Period());
    }

    public String toString() {
        return ToString.builder((String)"UdpGroupSettings").add("InputLossAction", (Object)this.inputLossActionString()).add("TimedMetadataId3Frame", (Object)this.timedMetadataId3FrameString()).add("TimedMetadataId3Period", (Object)this.timedMetadataId3Period()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputLossAction": {
                return Optional.of(clazz.cast(this.inputLossActionString()));
            }
            case "TimedMetadataId3Frame": {
                return Optional.of(clazz.cast(this.timedMetadataId3FrameString()));
            }
            case "TimedMetadataId3Period": {
                return Optional.of(clazz.cast(this.timedMetadataId3Period()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UdpGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputLossAction;
        private String timedMetadataId3Frame;
        private Integer timedMetadataId3Period;

        private BuilderImpl() {
        }

        private BuilderImpl(UdpGroupSettings model) {
            this.inputLossAction(model.inputLossAction);
            this.timedMetadataId3Frame(model.timedMetadataId3Frame);
            this.timedMetadataId3Period(model.timedMetadataId3Period);
        }

        public final String getInputLossAction() {
            return this.inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForUdpOut inputLossAction) {
            this.inputLossAction(inputLossAction.toString());
            return this;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        public final String getTimedMetadataId3Frame() {
            return this.timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(UdpTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame.toString());
            return this;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        public final Integer getTimedMetadataId3Period() {
            return this.timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        public UdpGroupSettings build() {
            return new UdpGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UdpGroupSettings> {
        public Builder inputLossAction(String var1);

        public Builder inputLossAction(InputLossActionForUdpOut var1);

        public Builder timedMetadataId3Frame(String var1);

        public Builder timedMetadataId3Frame(UdpTimedMetadataId3Frame var1);

        public Builder timedMetadataId3Period(Integer var1);
    }
}

