/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings;
import software.amazon.awssdk.services.medialive.model.HlsOutputSettings;
import software.amazon.awssdk.services.medialive.model.MsSmoothOutputSettings;
import software.amazon.awssdk.services.medialive.model.UdpOutputSettings;
import software.amazon.awssdk.services.medialive.transform.OutputSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutputSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputSettings> {
    private final ArchiveOutputSettings archiveOutputSettings;
    private final HlsOutputSettings hlsOutputSettings;
    private final MsSmoothOutputSettings msSmoothOutputSettings;
    private final UdpOutputSettings udpOutputSettings;

    private OutputSettings(BuilderImpl builder) {
        this.archiveOutputSettings = builder.archiveOutputSettings;
        this.hlsOutputSettings = builder.hlsOutputSettings;
        this.msSmoothOutputSettings = builder.msSmoothOutputSettings;
        this.udpOutputSettings = builder.udpOutputSettings;
    }

    public ArchiveOutputSettings archiveOutputSettings() {
        return this.archiveOutputSettings;
    }

    public HlsOutputSettings hlsOutputSettings() {
        return this.hlsOutputSettings;
    }

    public MsSmoothOutputSettings msSmoothOutputSettings() {
        return this.msSmoothOutputSettings;
    }

    public UdpOutputSettings udpOutputSettings() {
        return this.udpOutputSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.msSmoothOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.udpOutputSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSettings)) {
            return false;
        }
        OutputSettings other = (OutputSettings)obj;
        return Objects.equals(this.archiveOutputSettings(), other.archiveOutputSettings()) && Objects.equals(this.hlsOutputSettings(), other.hlsOutputSettings()) && Objects.equals(this.msSmoothOutputSettings(), other.msSmoothOutputSettings()) && Objects.equals(this.udpOutputSettings(), other.udpOutputSettings());
    }

    public String toString() {
        return ToString.builder((String)"OutputSettings").add("ArchiveOutputSettings", (Object)this.archiveOutputSettings()).add("HlsOutputSettings", (Object)this.hlsOutputSettings()).add("MsSmoothOutputSettings", (Object)this.msSmoothOutputSettings()).add("UdpOutputSettings", (Object)this.udpOutputSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveOutputSettings": {
                return Optional.of(clazz.cast(this.archiveOutputSettings()));
            }
            case "HlsOutputSettings": {
                return Optional.of(clazz.cast(this.hlsOutputSettings()));
            }
            case "MsSmoothOutputSettings": {
                return Optional.of(clazz.cast(this.msSmoothOutputSettings()));
            }
            case "UdpOutputSettings": {
                return Optional.of(clazz.cast(this.udpOutputSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ArchiveOutputSettings archiveOutputSettings;
        private HlsOutputSettings hlsOutputSettings;
        private MsSmoothOutputSettings msSmoothOutputSettings;
        private UdpOutputSettings udpOutputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSettings model) {
            this.archiveOutputSettings(model.archiveOutputSettings);
            this.hlsOutputSettings(model.hlsOutputSettings);
            this.msSmoothOutputSettings(model.msSmoothOutputSettings);
            this.udpOutputSettings(model.udpOutputSettings);
        }

        public final ArchiveOutputSettings.Builder getArchiveOutputSettings() {
            return this.archiveOutputSettings != null ? this.archiveOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder archiveOutputSettings(ArchiveOutputSettings archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings;
            return this;
        }

        public final void setArchiveOutputSettings(ArchiveOutputSettings.BuilderImpl archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings != null ? archiveOutputSettings.build() : null;
        }

        public final HlsOutputSettings.Builder getHlsOutputSettings() {
            return this.hlsOutputSettings != null ? this.hlsOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsOutputSettings(HlsOutputSettings hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings;
            return this;
        }

        public final void setHlsOutputSettings(HlsOutputSettings.BuilderImpl hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings != null ? hlsOutputSettings.build() : null;
        }

        public final MsSmoothOutputSettings.Builder getMsSmoothOutputSettings() {
            return this.msSmoothOutputSettings != null ? this.msSmoothOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder msSmoothOutputSettings(MsSmoothOutputSettings msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings;
            return this;
        }

        public final void setMsSmoothOutputSettings(MsSmoothOutputSettings.BuilderImpl msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings != null ? msSmoothOutputSettings.build() : null;
        }

        public final UdpOutputSettings.Builder getUdpOutputSettings() {
            return this.udpOutputSettings != null ? this.udpOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder udpOutputSettings(UdpOutputSettings udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings;
            return this;
        }

        public final void setUdpOutputSettings(UdpOutputSettings.BuilderImpl udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings != null ? udpOutputSettings.build() : null;
        }

        public OutputSettings build() {
            return new OutputSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputSettings> {
        public Builder archiveOutputSettings(ArchiveOutputSettings var1);

        default public Builder archiveOutputSettings(Consumer<ArchiveOutputSettings.Builder> archiveOutputSettings) {
            return this.archiveOutputSettings((ArchiveOutputSettings)((ArchiveOutputSettings.Builder)ArchiveOutputSettings.builder().apply(archiveOutputSettings)).build());
        }

        public Builder hlsOutputSettings(HlsOutputSettings var1);

        default public Builder hlsOutputSettings(Consumer<HlsOutputSettings.Builder> hlsOutputSettings) {
            return this.hlsOutputSettings((HlsOutputSettings)((HlsOutputSettings.Builder)HlsOutputSettings.builder().apply(hlsOutputSettings)).build());
        }

        public Builder msSmoothOutputSettings(MsSmoothOutputSettings var1);

        default public Builder msSmoothOutputSettings(Consumer<MsSmoothOutputSettings.Builder> msSmoothOutputSettings) {
            return this.msSmoothOutputSettings((MsSmoothOutputSettings)((MsSmoothOutputSettings.Builder)MsSmoothOutputSettings.builder().apply(msSmoothOutputSettings)).build());
        }

        public Builder udpOutputSettings(UdpOutputSettings var1);

        default public Builder udpOutputSettings(Consumer<UdpOutputSettings.Builder> udpOutputSettings) {
            return this.udpOutputSettings((UdpOutputSettings)((UdpOutputSettings.Builder)UdpOutputSettings.builder().apply(udpOutputSettings)).build());
        }
    }
}

