/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.ListOf__stringCopier;
import software.amazon.awssdk.services.medialive.model.OutputSettings;
import software.amazon.awssdk.services.medialive.transform.OutputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Output
implements StructuredPojo,
ToCopyableBuilder<Builder, Output> {
    private final List<String> audioDescriptionNames;
    private final List<String> captionDescriptionNames;
    private final String outputName;
    private final OutputSettings outputSettings;
    private final String videoDescriptionName;

    private Output(BuilderImpl builder) {
        this.audioDescriptionNames = builder.audioDescriptionNames;
        this.captionDescriptionNames = builder.captionDescriptionNames;
        this.outputName = builder.outputName;
        this.outputSettings = builder.outputSettings;
        this.videoDescriptionName = builder.videoDescriptionName;
    }

    public List<String> audioDescriptionNames() {
        return this.audioDescriptionNames;
    }

    public List<String> captionDescriptionNames() {
        return this.captionDescriptionNames;
    }

    public String outputName() {
        return this.outputName;
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public String videoDescriptionName() {
        return this.videoDescriptionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDescriptionNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionDescriptionNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoDescriptionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return Objects.equals(this.audioDescriptionNames(), other.audioDescriptionNames()) && Objects.equals(this.captionDescriptionNames(), other.captionDescriptionNames()) && Objects.equals(this.outputName(), other.outputName()) && Objects.equals(this.outputSettings(), other.outputSettings()) && Objects.equals(this.videoDescriptionName(), other.videoDescriptionName());
    }

    public String toString() {
        return ToString.builder((String)"Output").add("AudioDescriptionNames", this.audioDescriptionNames()).add("CaptionDescriptionNames", this.captionDescriptionNames()).add("OutputName", (Object)this.outputName()).add("OutputSettings", (Object)this.outputSettings()).add("VideoDescriptionName", (Object)this.videoDescriptionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptionNames": {
                return Optional.of(clazz.cast(this.audioDescriptionNames()));
            }
            case "CaptionDescriptionNames": {
                return Optional.of(clazz.cast(this.captionDescriptionNames()));
            }
            case "OutputName": {
                return Optional.of(clazz.cast(this.outputName()));
            }
            case "OutputSettings": {
                return Optional.of(clazz.cast(this.outputSettings()));
            }
            case "VideoDescriptionName": {
                return Optional.of(clazz.cast(this.videoDescriptionName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> audioDescriptionNames;
        private List<String> captionDescriptionNames;
        private String outputName;
        private OutputSettings outputSettings;
        private String videoDescriptionName;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.audioDescriptionNames(model.audioDescriptionNames);
            this.captionDescriptionNames(model.captionDescriptionNames);
            this.outputName(model.outputName);
            this.outputSettings(model.outputSettings);
            this.videoDescriptionName(model.videoDescriptionName);
        }

        public final Collection<String> getAudioDescriptionNames() {
            return this.audioDescriptionNames;
        }

        @Override
        public final Builder audioDescriptionNames(Collection<String> audioDescriptionNames) {
            this.audioDescriptionNames = ListOf__stringCopier.copy(audioDescriptionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptionNames(String ... audioDescriptionNames) {
            this.audioDescriptionNames(Arrays.asList(audioDescriptionNames));
            return this;
        }

        public final void setAudioDescriptionNames(Collection<String> audioDescriptionNames) {
            this.audioDescriptionNames = ListOf__stringCopier.copy(audioDescriptionNames);
        }

        public final Collection<String> getCaptionDescriptionNames() {
            return this.captionDescriptionNames;
        }

        @Override
        public final Builder captionDescriptionNames(Collection<String> captionDescriptionNames) {
            this.captionDescriptionNames = ListOf__stringCopier.copy(captionDescriptionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptionNames(String ... captionDescriptionNames) {
            this.captionDescriptionNames(Arrays.asList(captionDescriptionNames));
            return this;
        }

        public final void setCaptionDescriptionNames(Collection<String> captionDescriptionNames) {
            this.captionDescriptionNames = ListOf__stringCopier.copy(captionDescriptionNames);
        }

        public final String getOutputName() {
            return this.outputName;
        }

        @Override
        public final Builder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        public final void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        public final OutputSettings.Builder getOutputSettings() {
            return this.outputSettings != null ? this.outputSettings.toBuilder() : null;
        }

        @Override
        public final Builder outputSettings(OutputSettings outputSettings) {
            this.outputSettings = outputSettings;
            return this;
        }

        public final void setOutputSettings(OutputSettings.BuilderImpl outputSettings) {
            this.outputSettings = outputSettings != null ? outputSettings.build() : null;
        }

        public final String getVideoDescriptionName() {
            return this.videoDescriptionName;
        }

        @Override
        public final Builder videoDescriptionName(String videoDescriptionName) {
            this.videoDescriptionName = videoDescriptionName;
            return this;
        }

        public final void setVideoDescriptionName(String videoDescriptionName) {
            this.videoDescriptionName = videoDescriptionName;
        }

        public Output build() {
            return new Output(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Output> {
        public Builder audioDescriptionNames(Collection<String> var1);

        public Builder audioDescriptionNames(String ... var1);

        public Builder captionDescriptionNames(Collection<String> var1);

        public Builder captionDescriptionNames(String ... var1);

        public Builder outputName(String var1);

        public Builder outputSettings(OutputSettings var1);

        default public Builder outputSettings(Consumer<OutputSettings.Builder> outputSettings) {
            return this.outputSettings((OutputSettings)((OutputSettings.Builder)OutputSettings.builder().apply(outputSettings)).build());
        }

        public Builder videoDescriptionName(String var1);
    }
}

