/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.medialive.model.Input;
import software.amazon.awssdk.services.medialive.model.ListOfInputCopier;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInputsResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListInputsResponse> {
    private final List<Input> inputs;
    private final String nextToken;

    private ListInputsResponse(BuilderImpl builder) {
        super(builder);
        this.inputs = builder.inputs;
        this.nextToken = builder.nextToken;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputsResponse)) {
            return false;
        }
        ListInputsResponse other = (ListInputsResponse)((Object)obj);
        return Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInputsResponse").add("Inputs", this.inputs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Inputs": {
                return Optional.of(clazz.cast(this.inputs()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<Input> inputs;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputsResponse model) {
            this.inputs(model.inputs);
            this.nextToken(model.nextToken);
        }

        public final Collection<Input.Builder> getInputs() {
            return this.inputs != null ? (Collection)this.inputs.stream().map(Input::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = ListOfInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = ListOfInputCopier.copyFromBuilder(inputs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInputsResponse build() {
            return new ListInputsResponse(this);
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    CopyableBuilder<Builder, ListInputsResponse> {
        public Builder inputs(Collection<Input> var1);

        public Builder inputs(Input ... var1);

        public Builder nextToken(String var1);
    }
}

