/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.transform.InputSourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputSource
implements StructuredPojo,
ToCopyableBuilder<Builder, InputSource> {
    private final String passwordParam;
    private final String url;
    private final String username;

    private InputSource(BuilderImpl builder) {
        this.passwordParam = builder.passwordParam;
        this.url = builder.url;
        this.username = builder.username;
    }

    public String passwordParam() {
        return this.passwordParam;
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordParam());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSource)) {
            return false;
        }
        InputSource other = (InputSource)obj;
        return Objects.equals(this.passwordParam(), other.passwordParam()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"InputSource").add("PasswordParam", (Object)this.passwordParam()).add("Url", (Object)this.url()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PasswordParam": {
                return Optional.of(clazz.cast(this.passwordParam()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
            case "Username": {
                return Optional.of(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String passwordParam;
        private String url;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSource model) {
            this.passwordParam(model.passwordParam);
            this.url(model.url);
            this.username(model.username);
        }

        public final String getPasswordParam() {
            return this.passwordParam;
        }

        @Override
        public final Builder passwordParam(String passwordParam) {
            this.passwordParam = passwordParam;
            return this;
        }

        public final void setPasswordParam(String passwordParam) {
            this.passwordParam = passwordParam;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public InputSource build() {
            return new InputSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputSource> {
        public Builder passwordParam(String var1);

        public Builder url(String var1);

        public Builder username(String var1);
    }
}

