/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.transform.InputDestinationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputDestination
implements StructuredPojo,
ToCopyableBuilder<Builder, InputDestination> {
    private final String ip;
    private final String port;
    private final String url;

    private InputDestination(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.url = builder.url;
    }

    public String ip() {
        return this.ip;
    }

    public String port() {
        return this.port;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestination)) {
            return false;
        }
        InputDestination other = (InputDestination)obj;
        return Objects.equals(this.ip(), other.ip()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"InputDestination").add("Ip", (Object)this.ip()).add("Port", (Object)this.port()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ip": {
                return Optional.of(clazz.cast(this.ip()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ip;
        private String port;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestination model) {
            this.ip(model.ip);
            this.port(model.port);
            this.url(model.url);
        }

        public final String getIp() {
            return this.ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        public final String getPort() {
            return this.port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public InputDestination build() {
            return new InputDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputDestination> {
        public Builder ip(String var1);

        public Builder port(String var1);

        public Builder url(String var1);
    }
}

