/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsSettings;
import software.amazon.awssdk.services.medialive.transform.HlsOutputSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsOutputSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsOutputSettings> {
    private final HlsSettings hlsSettings;
    private final String nameModifier;
    private final String segmentModifier;

    private HlsOutputSettings(BuilderImpl builder) {
        this.hlsSettings = builder.hlsSettings;
        this.nameModifier = builder.nameModifier;
        this.segmentModifier = builder.segmentModifier;
    }

    public HlsSettings hlsSettings() {
        return this.hlsSettings;
    }

    public String nameModifier() {
        return this.nameModifier;
    }

    public String segmentModifier() {
        return this.segmentModifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentModifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsOutputSettings)) {
            return false;
        }
        HlsOutputSettings other = (HlsOutputSettings)obj;
        return Objects.equals(this.hlsSettings(), other.hlsSettings()) && Objects.equals(this.nameModifier(), other.nameModifier()) && Objects.equals(this.segmentModifier(), other.segmentModifier());
    }

    public String toString() {
        return ToString.builder((String)"HlsOutputSettings").add("HlsSettings", (Object)this.hlsSettings()).add("NameModifier", (Object)this.nameModifier()).add("SegmentModifier", (Object)this.segmentModifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HlsSettings": {
                return Optional.of(clazz.cast(this.hlsSettings()));
            }
            case "NameModifier": {
                return Optional.of(clazz.cast(this.nameModifier()));
            }
            case "SegmentModifier": {
                return Optional.of(clazz.cast(this.segmentModifier()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsOutputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private HlsSettings hlsSettings;
        private String nameModifier;
        private String segmentModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsOutputSettings model) {
            this.hlsSettings(model.hlsSettings);
            this.nameModifier(model.nameModifier);
            this.segmentModifier(model.segmentModifier);
        }

        public final HlsSettings.Builder getHlsSettings() {
            return this.hlsSettings != null ? this.hlsSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsSettings(HlsSettings hlsSettings) {
            this.hlsSettings = hlsSettings;
            return this;
        }

        public final void setHlsSettings(HlsSettings.BuilderImpl hlsSettings) {
            this.hlsSettings = hlsSettings != null ? hlsSettings.build() : null;
        }

        public final String getNameModifier() {
            return this.nameModifier;
        }

        @Override
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        public final String getSegmentModifier() {
            return this.segmentModifier;
        }

        @Override
        public final Builder segmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
            return this;
        }

        public final void setSegmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
        }

        public HlsOutputSettings build() {
            return new HlsOutputSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsOutputSettings> {
        public Builder hlsSettings(HlsSettings var1);

        default public Builder hlsSettings(Consumer<HlsSettings.Builder> hlsSettings) {
            return this.hlsSettings((HlsSettings)((HlsSettings.Builder)HlsSettings.builder().apply(hlsSettings)).build());
        }

        public Builder nameModifier(String var1);

        public Builder segmentModifier(String var1);
    }
}

