/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping;
import software.amazon.awssdk.services.medialive.model.HlsAdMarkers;
import software.amazon.awssdk.services.medialive.model.HlsCaptionLanguageSetting;
import software.amazon.awssdk.services.medialive.model.HlsCdnSettings;
import software.amazon.awssdk.services.medialive.model.HlsClientCache;
import software.amazon.awssdk.services.medialive.model.HlsCodecSpecification;
import software.amazon.awssdk.services.medialive.model.HlsDirectoryStructure;
import software.amazon.awssdk.services.medialive.model.HlsEncryptionType;
import software.amazon.awssdk.services.medialive.model.HlsIvInManifest;
import software.amazon.awssdk.services.medialive.model.HlsIvSource;
import software.amazon.awssdk.services.medialive.model.HlsManifestCompression;
import software.amazon.awssdk.services.medialive.model.HlsManifestDurationFormat;
import software.amazon.awssdk.services.medialive.model.HlsMode;
import software.amazon.awssdk.services.medialive.model.HlsOutputSelection;
import software.amazon.awssdk.services.medialive.model.HlsProgramDateTime;
import software.amazon.awssdk.services.medialive.model.HlsSegmentationMode;
import software.amazon.awssdk.services.medialive.model.HlsStreamInfResolution;
import software.amazon.awssdk.services.medialive.model.HlsTimedMetadataId3Frame;
import software.amazon.awssdk.services.medialive.model.HlsTsFileMode;
import software.amazon.awssdk.services.medialive.model.InputLossActionForHlsOut;
import software.amazon.awssdk.services.medialive.model.KeyProviderSettings;
import software.amazon.awssdk.services.medialive.model.ListOfCaptionLanguageMappingCopier;
import software.amazon.awssdk.services.medialive.model.ListOfHlsAdMarkersCopier;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.transform.HlsGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsGroupSettings> {
    private final List<String> adMarkers;
    private final String baseUrlContent;
    private final String baseUrlManifest;
    private final List<CaptionLanguageMapping> captionLanguageMappings;
    private final String captionLanguageSetting;
    private final String clientCache;
    private final String codecSpecification;
    private final String constantIv;
    private final OutputLocationRef destination;
    private final String directoryStructure;
    private final String encryptionType;
    private final HlsCdnSettings hlsCdnSettings;
    private final Integer indexNSegments;
    private final String inputLossAction;
    private final String ivInManifest;
    private final String ivSource;
    private final Integer keepSegments;
    private final String keyFormat;
    private final String keyFormatVersions;
    private final KeyProviderSettings keyProviderSettings;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Integer minSegmentLength;
    private final String mode;
    private final String outputSelection;
    private final String programDateTime;
    private final Integer programDateTimePeriod;
    private final Integer segmentLength;
    private final String segmentationMode;
    private final Integer segmentsPerSubdirectory;
    private final String streamInfResolution;
    private final String timedMetadataId3Frame;
    private final Integer timedMetadataId3Period;
    private final Integer timestampDeltaMilliseconds;
    private final String tsFileMode;

    private HlsGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.baseUrlContent = builder.baseUrlContent;
        this.baseUrlManifest = builder.baseUrlManifest;
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.captionLanguageSetting = builder.captionLanguageSetting;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.constantIv = builder.constantIv;
        this.destination = builder.destination;
        this.directoryStructure = builder.directoryStructure;
        this.encryptionType = builder.encryptionType;
        this.hlsCdnSettings = builder.hlsCdnSettings;
        this.indexNSegments = builder.indexNSegments;
        this.inputLossAction = builder.inputLossAction;
        this.ivInManifest = builder.ivInManifest;
        this.ivSource = builder.ivSource;
        this.keepSegments = builder.keepSegments;
        this.keyFormat = builder.keyFormat;
        this.keyFormatVersions = builder.keyFormatVersions;
        this.keyProviderSettings = builder.keyProviderSettings;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minSegmentLength = builder.minSegmentLength;
        this.mode = builder.mode;
        this.outputSelection = builder.outputSelection;
        this.programDateTime = builder.programDateTime;
        this.programDateTimePeriod = builder.programDateTimePeriod;
        this.segmentLength = builder.segmentLength;
        this.segmentationMode = builder.segmentationMode;
        this.segmentsPerSubdirectory = builder.segmentsPerSubdirectory;
        this.streamInfResolution = builder.streamInfResolution;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timestampDeltaMilliseconds = builder.timestampDeltaMilliseconds;
        this.tsFileMode = builder.tsFileMode;
    }

    public List<HlsAdMarkers> adMarkers() {
        return TypeConverter.convert(this.adMarkers, HlsAdMarkers::fromValue);
    }

    public List<String> adMarkersStrings() {
        return this.adMarkers;
    }

    public String baseUrlContent() {
        return this.baseUrlContent;
    }

    public String baseUrlManifest() {
        return this.baseUrlManifest;
    }

    public List<CaptionLanguageMapping> captionLanguageMappings() {
        return this.captionLanguageMappings;
    }

    public HlsCaptionLanguageSetting captionLanguageSetting() {
        return HlsCaptionLanguageSetting.fromValue(this.captionLanguageSetting);
    }

    public String captionLanguageSettingString() {
        return this.captionLanguageSetting;
    }

    public HlsClientCache clientCache() {
        return HlsClientCache.fromValue(this.clientCache);
    }

    public String clientCacheString() {
        return this.clientCache;
    }

    public HlsCodecSpecification codecSpecification() {
        return HlsCodecSpecification.fromValue(this.codecSpecification);
    }

    public String codecSpecificationString() {
        return this.codecSpecification;
    }

    public String constantIv() {
        return this.constantIv;
    }

    public OutputLocationRef destination() {
        return this.destination;
    }

    public HlsDirectoryStructure directoryStructure() {
        return HlsDirectoryStructure.fromValue(this.directoryStructure);
    }

    public String directoryStructureString() {
        return this.directoryStructure;
    }

    public HlsEncryptionType encryptionType() {
        return HlsEncryptionType.fromValue(this.encryptionType);
    }

    public String encryptionTypeString() {
        return this.encryptionType;
    }

    public HlsCdnSettings hlsCdnSettings() {
        return this.hlsCdnSettings;
    }

    public Integer indexNSegments() {
        return this.indexNSegments;
    }

    public InputLossActionForHlsOut inputLossAction() {
        return InputLossActionForHlsOut.fromValue(this.inputLossAction);
    }

    public String inputLossActionString() {
        return this.inputLossAction;
    }

    public HlsIvInManifest ivInManifest() {
        return HlsIvInManifest.fromValue(this.ivInManifest);
    }

    public String ivInManifestString() {
        return this.ivInManifest;
    }

    public HlsIvSource ivSource() {
        return HlsIvSource.fromValue(this.ivSource);
    }

    public String ivSourceString() {
        return this.ivSource;
    }

    public Integer keepSegments() {
        return this.keepSegments;
    }

    public String keyFormat() {
        return this.keyFormat;
    }

    public String keyFormatVersions() {
        return this.keyFormatVersions;
    }

    public KeyProviderSettings keyProviderSettings() {
        return this.keyProviderSettings;
    }

    public HlsManifestCompression manifestCompression() {
        return HlsManifestCompression.fromValue(this.manifestCompression);
    }

    public String manifestCompressionString() {
        return this.manifestCompression;
    }

    public HlsManifestDurationFormat manifestDurationFormat() {
        return HlsManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public String manifestDurationFormatString() {
        return this.manifestDurationFormat;
    }

    public Integer minSegmentLength() {
        return this.minSegmentLength;
    }

    public HlsMode mode() {
        return HlsMode.fromValue(this.mode);
    }

    public String modeString() {
        return this.mode;
    }

    public HlsOutputSelection outputSelection() {
        return HlsOutputSelection.fromValue(this.outputSelection);
    }

    public String outputSelectionString() {
        return this.outputSelection;
    }

    public HlsProgramDateTime programDateTime() {
        return HlsProgramDateTime.fromValue(this.programDateTime);
    }

    public String programDateTimeString() {
        return this.programDateTime;
    }

    public Integer programDateTimePeriod() {
        return this.programDateTimePeriod;
    }

    public Integer segmentLength() {
        return this.segmentLength;
    }

    public HlsSegmentationMode segmentationMode() {
        return HlsSegmentationMode.fromValue(this.segmentationMode);
    }

    public String segmentationModeString() {
        return this.segmentationMode;
    }

    public Integer segmentsPerSubdirectory() {
        return this.segmentsPerSubdirectory;
    }

    public HlsStreamInfResolution streamInfResolution() {
        return HlsStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public String streamInfResolutionString() {
        return this.streamInfResolution;
    }

    public HlsTimedMetadataId3Frame timedMetadataId3Frame() {
        return HlsTimedMetadataId3Frame.fromValue(this.timedMetadataId3Frame);
    }

    public String timedMetadataId3FrameString() {
        return this.timedMetadataId3Frame;
    }

    public Integer timedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public Integer timestampDeltaMilliseconds() {
        return this.timestampDeltaMilliseconds;
    }

    public HlsTsFileMode tsFileMode() {
        return HlsTsFileMode.fromValue(this.tsFileMode);
    }

    public String tsFileModeString() {
        return this.tsFileMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adMarkersStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrlContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrlManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionLanguageMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionLanguageSettingString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.constantIv());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryStructureString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsCdnSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexNSegments());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossActionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ivInManifestString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ivSourceString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepSegments());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormatVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyProviderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSelectionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsPerSubdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3FrameString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampDeltaMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tsFileModeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings)obj;
        return Objects.equals(this.adMarkersStrings(), other.adMarkersStrings()) && Objects.equals(this.baseUrlContent(), other.baseUrlContent()) && Objects.equals(this.baseUrlManifest(), other.baseUrlManifest()) && Objects.equals(this.captionLanguageMappings(), other.captionLanguageMappings()) && Objects.equals(this.captionLanguageSettingString(), other.captionLanguageSettingString()) && Objects.equals(this.clientCacheString(), other.clientCacheString()) && Objects.equals(this.codecSpecificationString(), other.codecSpecificationString()) && Objects.equals(this.constantIv(), other.constantIv()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.directoryStructureString(), other.directoryStructureString()) && Objects.equals(this.encryptionTypeString(), other.encryptionTypeString()) && Objects.equals(this.hlsCdnSettings(), other.hlsCdnSettings()) && Objects.equals(this.indexNSegments(), other.indexNSegments()) && Objects.equals(this.inputLossActionString(), other.inputLossActionString()) && Objects.equals(this.ivInManifestString(), other.ivInManifestString()) && Objects.equals(this.ivSourceString(), other.ivSourceString()) && Objects.equals(this.keepSegments(), other.keepSegments()) && Objects.equals(this.keyFormat(), other.keyFormat()) && Objects.equals(this.keyFormatVersions(), other.keyFormatVersions()) && Objects.equals(this.keyProviderSettings(), other.keyProviderSettings()) && Objects.equals(this.manifestCompressionString(), other.manifestCompressionString()) && Objects.equals(this.manifestDurationFormatString(), other.manifestDurationFormatString()) && Objects.equals(this.minSegmentLength(), other.minSegmentLength()) && Objects.equals(this.modeString(), other.modeString()) && Objects.equals(this.outputSelectionString(), other.outputSelectionString()) && Objects.equals(this.programDateTimeString(), other.programDateTimeString()) && Objects.equals(this.programDateTimePeriod(), other.programDateTimePeriod()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentationModeString(), other.segmentationModeString()) && Objects.equals(this.segmentsPerSubdirectory(), other.segmentsPerSubdirectory()) && Objects.equals(this.streamInfResolutionString(), other.streamInfResolutionString()) && Objects.equals(this.timedMetadataId3FrameString(), other.timedMetadataId3FrameString()) && Objects.equals(this.timedMetadataId3Period(), other.timedMetadataId3Period()) && Objects.equals(this.timestampDeltaMilliseconds(), other.timestampDeltaMilliseconds()) && Objects.equals(this.tsFileModeString(), other.tsFileModeString());
    }

    public String toString() {
        return ToString.builder((String)"HlsGroupSettings").add("AdMarkers", this.adMarkersStrings()).add("BaseUrlContent", (Object)this.baseUrlContent()).add("BaseUrlManifest", (Object)this.baseUrlManifest()).add("CaptionLanguageMappings", this.captionLanguageMappings()).add("CaptionLanguageSetting", (Object)this.captionLanguageSettingString()).add("ClientCache", (Object)this.clientCacheString()).add("CodecSpecification", (Object)this.codecSpecificationString()).add("ConstantIv", (Object)this.constantIv()).add("Destination", (Object)this.destination()).add("DirectoryStructure", (Object)this.directoryStructureString()).add("EncryptionType", (Object)this.encryptionTypeString()).add("HlsCdnSettings", (Object)this.hlsCdnSettings()).add("IndexNSegments", (Object)this.indexNSegments()).add("InputLossAction", (Object)this.inputLossActionString()).add("IvInManifest", (Object)this.ivInManifestString()).add("IvSource", (Object)this.ivSourceString()).add("KeepSegments", (Object)this.keepSegments()).add("KeyFormat", (Object)this.keyFormat()).add("KeyFormatVersions", (Object)this.keyFormatVersions()).add("KeyProviderSettings", (Object)this.keyProviderSettings()).add("ManifestCompression", (Object)this.manifestCompressionString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatString()).add("MinSegmentLength", (Object)this.minSegmentLength()).add("Mode", (Object)this.modeString()).add("OutputSelection", (Object)this.outputSelectionString()).add("ProgramDateTime", (Object)this.programDateTimeString()).add("ProgramDateTimePeriod", (Object)this.programDateTimePeriod()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentationMode", (Object)this.segmentationModeString()).add("SegmentsPerSubdirectory", (Object)this.segmentsPerSubdirectory()).add("StreamInfResolution", (Object)this.streamInfResolutionString()).add("TimedMetadataId3Frame", (Object)this.timedMetadataId3FrameString()).add("TimedMetadataId3Period", (Object)this.timedMetadataId3Period()).add("TimestampDeltaMilliseconds", (Object)this.timestampDeltaMilliseconds()).add("TsFileMode", (Object)this.tsFileModeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.of(clazz.cast(this.adMarkersStrings()));
            }
            case "BaseUrlContent": {
                return Optional.of(clazz.cast(this.baseUrlContent()));
            }
            case "BaseUrlManifest": {
                return Optional.of(clazz.cast(this.baseUrlManifest()));
            }
            case "CaptionLanguageMappings": {
                return Optional.of(clazz.cast(this.captionLanguageMappings()));
            }
            case "CaptionLanguageSetting": {
                return Optional.of(clazz.cast(this.captionLanguageSettingString()));
            }
            case "ClientCache": {
                return Optional.of(clazz.cast(this.clientCacheString()));
            }
            case "CodecSpecification": {
                return Optional.of(clazz.cast(this.codecSpecificationString()));
            }
            case "ConstantIv": {
                return Optional.of(clazz.cast(this.constantIv()));
            }
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
            case "DirectoryStructure": {
                return Optional.of(clazz.cast(this.directoryStructureString()));
            }
            case "EncryptionType": {
                return Optional.of(clazz.cast(this.encryptionTypeString()));
            }
            case "HlsCdnSettings": {
                return Optional.of(clazz.cast(this.hlsCdnSettings()));
            }
            case "IndexNSegments": {
                return Optional.of(clazz.cast(this.indexNSegments()));
            }
            case "InputLossAction": {
                return Optional.of(clazz.cast(this.inputLossActionString()));
            }
            case "IvInManifest": {
                return Optional.of(clazz.cast(this.ivInManifestString()));
            }
            case "IvSource": {
                return Optional.of(clazz.cast(this.ivSourceString()));
            }
            case "KeepSegments": {
                return Optional.of(clazz.cast(this.keepSegments()));
            }
            case "KeyFormat": {
                return Optional.of(clazz.cast(this.keyFormat()));
            }
            case "KeyFormatVersions": {
                return Optional.of(clazz.cast(this.keyFormatVersions()));
            }
            case "KeyProviderSettings": {
                return Optional.of(clazz.cast(this.keyProviderSettings()));
            }
            case "ManifestCompression": {
                return Optional.of(clazz.cast(this.manifestCompressionString()));
            }
            case "ManifestDurationFormat": {
                return Optional.of(clazz.cast(this.manifestDurationFormatString()));
            }
            case "MinSegmentLength": {
                return Optional.of(clazz.cast(this.minSegmentLength()));
            }
            case "Mode": {
                return Optional.of(clazz.cast(this.modeString()));
            }
            case "OutputSelection": {
                return Optional.of(clazz.cast(this.outputSelectionString()));
            }
            case "ProgramDateTime": {
                return Optional.of(clazz.cast(this.programDateTimeString()));
            }
            case "ProgramDateTimePeriod": {
                return Optional.of(clazz.cast(this.programDateTimePeriod()));
            }
            case "SegmentLength": {
                return Optional.of(clazz.cast(this.segmentLength()));
            }
            case "SegmentationMode": {
                return Optional.of(clazz.cast(this.segmentationModeString()));
            }
            case "SegmentsPerSubdirectory": {
                return Optional.of(clazz.cast(this.segmentsPerSubdirectory()));
            }
            case "StreamInfResolution": {
                return Optional.of(clazz.cast(this.streamInfResolutionString()));
            }
            case "TimedMetadataId3Frame": {
                return Optional.of(clazz.cast(this.timedMetadataId3FrameString()));
            }
            case "TimedMetadataId3Period": {
                return Optional.of(clazz.cast(this.timedMetadataId3Period()));
            }
            case "TimestampDeltaMilliseconds": {
                return Optional.of(clazz.cast(this.timestampDeltaMilliseconds()));
            }
            case "TsFileMode": {
                return Optional.of(clazz.cast(this.tsFileModeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> adMarkers;
        private String baseUrlContent;
        private String baseUrlManifest;
        private List<CaptionLanguageMapping> captionLanguageMappings;
        private String captionLanguageSetting;
        private String clientCache;
        private String codecSpecification;
        private String constantIv;
        private OutputLocationRef destination;
        private String directoryStructure;
        private String encryptionType;
        private HlsCdnSettings hlsCdnSettings;
        private Integer indexNSegments;
        private String inputLossAction;
        private String ivInManifest;
        private String ivSource;
        private Integer keepSegments;
        private String keyFormat;
        private String keyFormatVersions;
        private KeyProviderSettings keyProviderSettings;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Integer minSegmentLength;
        private String mode;
        private String outputSelection;
        private String programDateTime;
        private Integer programDateTimePeriod;
        private Integer segmentLength;
        private String segmentationMode;
        private Integer segmentsPerSubdirectory;
        private String streamInfResolution;
        private String timedMetadataId3Frame;
        private Integer timedMetadataId3Period;
        private Integer timestampDeltaMilliseconds;
        private String tsFileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsGroupSettings model) {
            this.adMarkers(model.adMarkers);
            this.baseUrlContent(model.baseUrlContent);
            this.baseUrlManifest(model.baseUrlManifest);
            this.captionLanguageMappings(model.captionLanguageMappings);
            this.captionLanguageSetting(model.captionLanguageSetting);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.constantIv(model.constantIv);
            this.destination(model.destination);
            this.directoryStructure(model.directoryStructure);
            this.encryptionType(model.encryptionType);
            this.hlsCdnSettings(model.hlsCdnSettings);
            this.indexNSegments(model.indexNSegments);
            this.inputLossAction(model.inputLossAction);
            this.ivInManifest(model.ivInManifest);
            this.ivSource(model.ivSource);
            this.keepSegments(model.keepSegments);
            this.keyFormat(model.keyFormat);
            this.keyFormatVersions(model.keyFormatVersions);
            this.keyProviderSettings(model.keyProviderSettings);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minSegmentLength(model.minSegmentLength);
            this.mode(model.mode);
            this.outputSelection(model.outputSelection);
            this.programDateTime(model.programDateTime);
            this.programDateTimePeriod(model.programDateTimePeriod);
            this.segmentLength(model.segmentLength);
            this.segmentationMode(model.segmentationMode);
            this.segmentsPerSubdirectory(model.segmentsPerSubdirectory);
            this.streamInfResolution(model.streamInfResolution);
            this.timedMetadataId3Frame(model.timedMetadataId3Frame);
            this.timedMetadataId3Period(model.timedMetadataId3Period);
            this.timestampDeltaMilliseconds(model.timestampDeltaMilliseconds);
            this.tsFileMode(model.tsFileMode);
        }

        public final Collection<String> getAdMarkers() {
            return this.adMarkers;
        }

        @Override
        public final Builder adMarkers(Collection<String> adMarkers) {
            this.adMarkers = ListOfHlsAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkers(String ... adMarkers) {
            this.adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ListOfHlsAdMarkersCopier.copy(adMarkers);
        }

        public final String getBaseUrlContent() {
            return this.baseUrlContent;
        }

        @Override
        public final Builder baseUrlContent(String baseUrlContent) {
            this.baseUrlContent = baseUrlContent;
            return this;
        }

        public final void setBaseUrlContent(String baseUrlContent) {
            this.baseUrlContent = baseUrlContent;
        }

        public final String getBaseUrlManifest() {
            return this.baseUrlManifest;
        }

        @Override
        public final Builder baseUrlManifest(String baseUrlManifest) {
            this.baseUrlManifest = baseUrlManifest;
            return this;
        }

        public final void setBaseUrlManifest(String baseUrlManifest) {
            this.baseUrlManifest = baseUrlManifest;
        }

        public final Collection<CaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            return this.captionLanguageMappings != null ? (Collection)this.captionLanguageMappings.stream().map(CaptionLanguageMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionLanguageMappings(Collection<CaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ListOfCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(CaptionLanguageMapping ... captionLanguageMappings) {
            this.captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        public final void setCaptionLanguageMappings(Collection<CaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ListOfCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        public final String getCaptionLanguageSetting() {
            return this.captionLanguageSetting;
        }

        @Override
        public final Builder captionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
            return this;
        }

        @Override
        public final Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
            this.captionLanguageSetting(captionLanguageSetting.toString());
            return this;
        }

        public final void setCaptionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
        }

        public final String getClientCache() {
            return this.clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(HlsClientCache clientCache) {
            this.clientCache(clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecification() {
            return this.codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(HlsCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getConstantIv() {
            return this.constantIv;
        }

        @Override
        public final Builder constantIv(String constantIv) {
            this.constantIv = constantIv;
            return this;
        }

        public final void setConstantIv(String constantIv) {
            this.constantIv = constantIv;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final String getDirectoryStructure() {
            return this.directoryStructure;
        }

        @Override
        public final Builder directoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
            return this;
        }

        @Override
        public final Builder directoryStructure(HlsDirectoryStructure directoryStructure) {
            this.directoryStructure(directoryStructure.toString());
            return this;
        }

        public final void setDirectoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(HlsEncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final HlsCdnSettings.Builder getHlsCdnSettings() {
            return this.hlsCdnSettings != null ? this.hlsCdnSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsCdnSettings(HlsCdnSettings hlsCdnSettings) {
            this.hlsCdnSettings = hlsCdnSettings;
            return this;
        }

        public final void setHlsCdnSettings(HlsCdnSettings.BuilderImpl hlsCdnSettings) {
            this.hlsCdnSettings = hlsCdnSettings != null ? hlsCdnSettings.build() : null;
        }

        public final Integer getIndexNSegments() {
            return this.indexNSegments;
        }

        @Override
        public final Builder indexNSegments(Integer indexNSegments) {
            this.indexNSegments = indexNSegments;
            return this;
        }

        public final void setIndexNSegments(Integer indexNSegments) {
            this.indexNSegments = indexNSegments;
        }

        public final String getInputLossAction() {
            return this.inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForHlsOut inputLossAction) {
            this.inputLossAction(inputLossAction.toString());
            return this;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        public final String getIvInManifest() {
            return this.ivInManifest;
        }

        @Override
        public final Builder ivInManifest(String ivInManifest) {
            this.ivInManifest = ivInManifest;
            return this;
        }

        @Override
        public final Builder ivInManifest(HlsIvInManifest ivInManifest) {
            this.ivInManifest(ivInManifest.toString());
            return this;
        }

        public final void setIvInManifest(String ivInManifest) {
            this.ivInManifest = ivInManifest;
        }

        public final String getIvSource() {
            return this.ivSource;
        }

        @Override
        public final Builder ivSource(String ivSource) {
            this.ivSource = ivSource;
            return this;
        }

        @Override
        public final Builder ivSource(HlsIvSource ivSource) {
            this.ivSource(ivSource.toString());
            return this;
        }

        public final void setIvSource(String ivSource) {
            this.ivSource = ivSource;
        }

        public final Integer getKeepSegments() {
            return this.keepSegments;
        }

        @Override
        public final Builder keepSegments(Integer keepSegments) {
            this.keepSegments = keepSegments;
            return this;
        }

        public final void setKeepSegments(Integer keepSegments) {
            this.keepSegments = keepSegments;
        }

        public final String getKeyFormat() {
            return this.keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        public final String getKeyFormatVersions() {
            return this.keyFormatVersions;
        }

        @Override
        public final Builder keyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
            return this;
        }

        public final void setKeyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
        }

        public final KeyProviderSettings.Builder getKeyProviderSettings() {
            return this.keyProviderSettings != null ? this.keyProviderSettings.toBuilder() : null;
        }

        @Override
        public final Builder keyProviderSettings(KeyProviderSettings keyProviderSettings) {
            this.keyProviderSettings = keyProviderSettings;
            return this;
        }

        public final void setKeyProviderSettings(KeyProviderSettings.BuilderImpl keyProviderSettings) {
            this.keyProviderSettings = keyProviderSettings != null ? keyProviderSettings.build() : null;
        }

        public final String getManifestCompression() {
            return this.manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(HlsManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormat() {
            return this.manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Integer getMinSegmentLength() {
            return this.minSegmentLength;
        }

        @Override
        public final Builder minSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
            return this;
        }

        public final void setMinSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(HlsMode mode) {
            this.mode(mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getOutputSelection() {
            return this.outputSelection;
        }

        @Override
        public final Builder outputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
            return this;
        }

        @Override
        public final Builder outputSelection(HlsOutputSelection outputSelection) {
            this.outputSelection(outputSelection.toString());
            return this;
        }

        public final void setOutputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
        }

        public final String getProgramDateTime() {
            return this.programDateTime;
        }

        @Override
        public final Builder programDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
            return this;
        }

        @Override
        public final Builder programDateTime(HlsProgramDateTime programDateTime) {
            this.programDateTime(programDateTime.toString());
            return this;
        }

        public final void setProgramDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
        }

        public final Integer getProgramDateTimePeriod() {
            return this.programDateTimePeriod;
        }

        @Override
        public final Builder programDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
            return this;
        }

        public final void setProgramDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final String getSegmentationMode() {
            return this.segmentationMode;
        }

        @Override
        public final Builder segmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
            return this;
        }

        @Override
        public final Builder segmentationMode(HlsSegmentationMode segmentationMode) {
            this.segmentationMode(segmentationMode.toString());
            return this;
        }

        public final void setSegmentationMode(String segmentationMode) {
            this.segmentationMode = segmentationMode;
        }

        public final Integer getSegmentsPerSubdirectory() {
            return this.segmentsPerSubdirectory;
        }

        @Override
        public final Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
            return this;
        }

        public final void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
        }

        public final String getStreamInfResolution() {
            return this.streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(HlsStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getTimedMetadataId3Frame() {
            return this.timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame.toString());
            return this;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        public final Integer getTimedMetadataId3Period() {
            return this.timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        public final Integer getTimestampDeltaMilliseconds() {
            return this.timestampDeltaMilliseconds;
        }

        @Override
        public final Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
            return this;
        }

        public final void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
        }

        public final String getTsFileMode() {
            return this.tsFileMode;
        }

        @Override
        public final Builder tsFileMode(String tsFileMode) {
            this.tsFileMode = tsFileMode;
            return this;
        }

        @Override
        public final Builder tsFileMode(HlsTsFileMode tsFileMode) {
            this.tsFileMode(tsFileMode.toString());
            return this;
        }

        public final void setTsFileMode(String tsFileMode) {
            this.tsFileMode = tsFileMode;
        }

        public HlsGroupSettings build() {
            return new HlsGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsGroupSettings> {
        public Builder adMarkers(Collection<String> var1);

        public Builder adMarkers(String ... var1);

        public Builder baseUrlContent(String var1);

        public Builder baseUrlManifest(String var1);

        public Builder captionLanguageMappings(Collection<CaptionLanguageMapping> var1);

        public Builder captionLanguageMappings(CaptionLanguageMapping ... var1);

        public Builder captionLanguageSetting(String var1);

        public Builder captionLanguageSetting(HlsCaptionLanguageSetting var1);

        public Builder clientCache(String var1);

        public Builder clientCache(HlsClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(HlsCodecSpecification var1);

        public Builder constantIv(String var1);

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().apply(destination)).build());
        }

        public Builder directoryStructure(String var1);

        public Builder directoryStructure(HlsDirectoryStructure var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(HlsEncryptionType var1);

        public Builder hlsCdnSettings(HlsCdnSettings var1);

        default public Builder hlsCdnSettings(Consumer<HlsCdnSettings.Builder> hlsCdnSettings) {
            return this.hlsCdnSettings((HlsCdnSettings)((HlsCdnSettings.Builder)HlsCdnSettings.builder().apply(hlsCdnSettings)).build());
        }

        public Builder indexNSegments(Integer var1);

        public Builder inputLossAction(String var1);

        public Builder inputLossAction(InputLossActionForHlsOut var1);

        public Builder ivInManifest(String var1);

        public Builder ivInManifest(HlsIvInManifest var1);

        public Builder ivSource(String var1);

        public Builder ivSource(HlsIvSource var1);

        public Builder keepSegments(Integer var1);

        public Builder keyFormat(String var1);

        public Builder keyFormatVersions(String var1);

        public Builder keyProviderSettings(KeyProviderSettings var1);

        default public Builder keyProviderSettings(Consumer<KeyProviderSettings.Builder> keyProviderSettings) {
            return this.keyProviderSettings((KeyProviderSettings)((KeyProviderSettings.Builder)KeyProviderSettings.builder().apply(keyProviderSettings)).build());
        }

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(HlsManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(HlsManifestDurationFormat var1);

        public Builder minSegmentLength(Integer var1);

        public Builder mode(String var1);

        public Builder mode(HlsMode var1);

        public Builder outputSelection(String var1);

        public Builder outputSelection(HlsOutputSelection var1);

        public Builder programDateTime(String var1);

        public Builder programDateTime(HlsProgramDateTime var1);

        public Builder programDateTimePeriod(Integer var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentationMode(String var1);

        public Builder segmentationMode(HlsSegmentationMode var1);

        public Builder segmentsPerSubdirectory(Integer var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(HlsStreamInfResolution var1);

        public Builder timedMetadataId3Frame(String var1);

        public Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame var1);

        public Builder timedMetadataId3Period(Integer var1);

        public Builder timestampDeltaMilliseconds(Integer var1);

        public Builder tsFileMode(String var1);

        public Builder tsFileMode(HlsTsFileMode var1);
    }
}

