/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsAkamaiHttpTransferMode;
import software.amazon.awssdk.services.medialive.transform.HlsAkamaiSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsAkamaiSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsAkamaiSettings> {
    private final Integer connectionRetryInterval;
    private final Integer filecacheDuration;
    private final String httpTransferMode;
    private final Integer numRetries;
    private final Integer restartDelay;
    private final String salt;
    private final String token;

    private HlsAkamaiSettings(BuilderImpl builder) {
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.filecacheDuration = builder.filecacheDuration;
        this.httpTransferMode = builder.httpTransferMode;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
        this.salt = builder.salt;
        this.token = builder.token;
    }

    public Integer connectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public Integer filecacheDuration() {
        return this.filecacheDuration;
    }

    public HlsAkamaiHttpTransferMode httpTransferMode() {
        return HlsAkamaiHttpTransferMode.fromValue(this.httpTransferMode);
    }

    public String httpTransferModeString() {
        return this.httpTransferMode;
    }

    public Integer numRetries() {
        return this.numRetries;
    }

    public Integer restartDelay() {
        return this.restartDelay;
    }

    public String salt() {
        return this.salt;
    }

    public String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTransferModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        hashCode = 31 * hashCode + Objects.hashCode(this.salt());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsAkamaiSettings)) {
            return false;
        }
        HlsAkamaiSettings other = (HlsAkamaiSettings)obj;
        return Objects.equals(this.connectionRetryInterval(), other.connectionRetryInterval()) && Objects.equals(this.filecacheDuration(), other.filecacheDuration()) && Objects.equals(this.httpTransferModeString(), other.httpTransferModeString()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.restartDelay(), other.restartDelay()) && Objects.equals(this.salt(), other.salt()) && Objects.equals(this.token(), other.token());
    }

    public String toString() {
        return ToString.builder((String)"HlsAkamaiSettings").add("ConnectionRetryInterval", (Object)this.connectionRetryInterval()).add("FilecacheDuration", (Object)this.filecacheDuration()).add("HttpTransferMode", (Object)this.httpTransferModeString()).add("NumRetries", (Object)this.numRetries()).add("RestartDelay", (Object)this.restartDelay()).add("Salt", (Object)this.salt()).add("Token", (Object)this.token()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionRetryInterval": {
                return Optional.of(clazz.cast(this.connectionRetryInterval()));
            }
            case "FilecacheDuration": {
                return Optional.of(clazz.cast(this.filecacheDuration()));
            }
            case "HttpTransferMode": {
                return Optional.of(clazz.cast(this.httpTransferModeString()));
            }
            case "NumRetries": {
                return Optional.of(clazz.cast(this.numRetries()));
            }
            case "RestartDelay": {
                return Optional.of(clazz.cast(this.restartDelay()));
            }
            case "Salt": {
                return Optional.of(clazz.cast(this.salt()));
            }
            case "Token": {
                return Optional.of(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsAkamaiSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer connectionRetryInterval;
        private Integer filecacheDuration;
        private String httpTransferMode;
        private Integer numRetries;
        private Integer restartDelay;
        private String salt;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsAkamaiSettings model) {
            this.connectionRetryInterval(model.connectionRetryInterval);
            this.filecacheDuration(model.filecacheDuration);
            this.httpTransferMode(model.httpTransferMode);
            this.numRetries(model.numRetries);
            this.restartDelay(model.restartDelay);
            this.salt(model.salt);
            this.token(model.token);
        }

        public final Integer getConnectionRetryInterval() {
            return this.connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public final Integer getFilecacheDuration() {
            return this.filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        public final String getHttpTransferMode() {
            return this.httpTransferMode;
        }

        @Override
        public final Builder httpTransferMode(String httpTransferMode) {
            this.httpTransferMode = httpTransferMode;
            return this;
        }

        @Override
        public final Builder httpTransferMode(HlsAkamaiHttpTransferMode httpTransferMode) {
            this.httpTransferMode(httpTransferMode.toString());
            return this;
        }

        public final void setHttpTransferMode(String httpTransferMode) {
            this.httpTransferMode = httpTransferMode;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        public final String getSalt() {
            return this.salt;
        }

        @Override
        public final Builder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public final void setSalt(String salt) {
            this.salt = salt;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public HlsAkamaiSettings build() {
            return new HlsAkamaiSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsAkamaiSettings> {
        public Builder connectionRetryInterval(Integer var1);

        public Builder filecacheDuration(Integer var1);

        public Builder httpTransferMode(String var1);

        public Builder httpTransferMode(HlsAkamaiHttpTransferMode var1);

        public Builder numRetries(Integer var1);

        public Builder restartDelay(Integer var1);

        public Builder salt(String var1);

        public Builder token(String var1);
    }
}

