/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.GlobalConfigurationInputEndAction;
import software.amazon.awssdk.services.medialive.model.GlobalConfigurationLowFramerateInputs;
import software.amazon.awssdk.services.medialive.model.GlobalConfigurationOutputTimingSource;
import software.amazon.awssdk.services.medialive.model.InputLossBehavior;
import software.amazon.awssdk.services.medialive.transform.GlobalConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GlobalConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, GlobalConfiguration> {
    private final Integer initialAudioGain;
    private final String inputEndAction;
    private final InputLossBehavior inputLossBehavior;
    private final String outputTimingSource;
    private final String supportLowFramerateInputs;

    private GlobalConfiguration(BuilderImpl builder) {
        this.initialAudioGain = builder.initialAudioGain;
        this.inputEndAction = builder.inputEndAction;
        this.inputLossBehavior = builder.inputLossBehavior;
        this.outputTimingSource = builder.outputTimingSource;
        this.supportLowFramerateInputs = builder.supportLowFramerateInputs;
    }

    public Integer initialAudioGain() {
        return this.initialAudioGain;
    }

    public GlobalConfigurationInputEndAction inputEndAction() {
        return GlobalConfigurationInputEndAction.fromValue(this.inputEndAction);
    }

    public String inputEndActionString() {
        return this.inputEndAction;
    }

    public InputLossBehavior inputLossBehavior() {
        return this.inputLossBehavior;
    }

    public GlobalConfigurationOutputTimingSource outputTimingSource() {
        return GlobalConfigurationOutputTimingSource.fromValue(this.outputTimingSource);
    }

    public String outputTimingSourceString() {
        return this.outputTimingSource;
    }

    public GlobalConfigurationLowFramerateInputs supportLowFramerateInputs() {
        return GlobalConfigurationLowFramerateInputs.fromValue(this.supportLowFramerateInputs);
    }

    public String supportLowFramerateInputsString() {
        return this.supportLowFramerateInputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.initialAudioGain());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputEndActionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTimingSourceString());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportLowFramerateInputsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalConfiguration)) {
            return false;
        }
        GlobalConfiguration other = (GlobalConfiguration)obj;
        return Objects.equals(this.initialAudioGain(), other.initialAudioGain()) && Objects.equals(this.inputEndActionString(), other.inputEndActionString()) && Objects.equals(this.inputLossBehavior(), other.inputLossBehavior()) && Objects.equals(this.outputTimingSourceString(), other.outputTimingSourceString()) && Objects.equals(this.supportLowFramerateInputsString(), other.supportLowFramerateInputsString());
    }

    public String toString() {
        return ToString.builder((String)"GlobalConfiguration").add("InitialAudioGain", (Object)this.initialAudioGain()).add("InputEndAction", (Object)this.inputEndActionString()).add("InputLossBehavior", (Object)this.inputLossBehavior()).add("OutputTimingSource", (Object)this.outputTimingSourceString()).add("SupportLowFramerateInputs", (Object)this.supportLowFramerateInputsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InitialAudioGain": {
                return Optional.of(clazz.cast(this.initialAudioGain()));
            }
            case "InputEndAction": {
                return Optional.of(clazz.cast(this.inputEndActionString()));
            }
            case "InputLossBehavior": {
                return Optional.of(clazz.cast(this.inputLossBehavior()));
            }
            case "OutputTimingSource": {
                return Optional.of(clazz.cast(this.outputTimingSourceString()));
            }
            case "SupportLowFramerateInputs": {
                return Optional.of(clazz.cast(this.supportLowFramerateInputsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer initialAudioGain;
        private String inputEndAction;
        private InputLossBehavior inputLossBehavior;
        private String outputTimingSource;
        private String supportLowFramerateInputs;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalConfiguration model) {
            this.initialAudioGain(model.initialAudioGain);
            this.inputEndAction(model.inputEndAction);
            this.inputLossBehavior(model.inputLossBehavior);
            this.outputTimingSource(model.outputTimingSource);
            this.supportLowFramerateInputs(model.supportLowFramerateInputs);
        }

        public final Integer getInitialAudioGain() {
            return this.initialAudioGain;
        }

        @Override
        public final Builder initialAudioGain(Integer initialAudioGain) {
            this.initialAudioGain = initialAudioGain;
            return this;
        }

        public final void setInitialAudioGain(Integer initialAudioGain) {
            this.initialAudioGain = initialAudioGain;
        }

        public final String getInputEndAction() {
            return this.inputEndAction;
        }

        @Override
        public final Builder inputEndAction(String inputEndAction) {
            this.inputEndAction = inputEndAction;
            return this;
        }

        @Override
        public final Builder inputEndAction(GlobalConfigurationInputEndAction inputEndAction) {
            this.inputEndAction(inputEndAction.toString());
            return this;
        }

        public final void setInputEndAction(String inputEndAction) {
            this.inputEndAction = inputEndAction;
        }

        public final InputLossBehavior.Builder getInputLossBehavior() {
            return this.inputLossBehavior != null ? this.inputLossBehavior.toBuilder() : null;
        }

        @Override
        public final Builder inputLossBehavior(InputLossBehavior inputLossBehavior) {
            this.inputLossBehavior = inputLossBehavior;
            return this;
        }

        public final void setInputLossBehavior(InputLossBehavior.BuilderImpl inputLossBehavior) {
            this.inputLossBehavior = inputLossBehavior != null ? inputLossBehavior.build() : null;
        }

        public final String getOutputTimingSource() {
            return this.outputTimingSource;
        }

        @Override
        public final Builder outputTimingSource(String outputTimingSource) {
            this.outputTimingSource = outputTimingSource;
            return this;
        }

        @Override
        public final Builder outputTimingSource(GlobalConfigurationOutputTimingSource outputTimingSource) {
            this.outputTimingSource(outputTimingSource.toString());
            return this;
        }

        public final void setOutputTimingSource(String outputTimingSource) {
            this.outputTimingSource = outputTimingSource;
        }

        public final String getSupportLowFramerateInputs() {
            return this.supportLowFramerateInputs;
        }

        @Override
        public final Builder supportLowFramerateInputs(String supportLowFramerateInputs) {
            this.supportLowFramerateInputs = supportLowFramerateInputs;
            return this;
        }

        @Override
        public final Builder supportLowFramerateInputs(GlobalConfigurationLowFramerateInputs supportLowFramerateInputs) {
            this.supportLowFramerateInputs(supportLowFramerateInputs.toString());
            return this;
        }

        public final void setSupportLowFramerateInputs(String supportLowFramerateInputs) {
            this.supportLowFramerateInputs = supportLowFramerateInputs;
        }

        public GlobalConfiguration build() {
            return new GlobalConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GlobalConfiguration> {
        public Builder initialAudioGain(Integer var1);

        public Builder inputEndAction(String var1);

        public Builder inputEndAction(GlobalConfigurationInputEndAction var1);

        public Builder inputLossBehavior(InputLossBehavior var1);

        default public Builder inputLossBehavior(Consumer<InputLossBehavior.Builder> inputLossBehavior) {
            return this.inputLossBehavior((InputLossBehavior)((InputLossBehavior.Builder)InputLossBehavior.builder().apply(inputLossBehavior)).build());
        }

        public Builder outputTimingSource(String var1);

        public Builder outputTimingSource(GlobalConfigurationOutputTimingSource var1);

        public Builder supportLowFramerateInputs(String var1);

        public Builder supportLowFramerateInputs(GlobalConfigurationLowFramerateInputs var1);
    }
}

