/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.DvbSubDestinationAlignment;
import software.amazon.awssdk.services.medialive.model.DvbSubDestinationBackgroundColor;
import software.amazon.awssdk.services.medialive.model.DvbSubDestinationFontColor;
import software.amazon.awssdk.services.medialive.model.DvbSubDestinationOutlineColor;
import software.amazon.awssdk.services.medialive.model.DvbSubDestinationShadowColor;
import software.amazon.awssdk.services.medialive.model.DvbSubDestinationTeletextGridControl;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.services.medialive.transform.DvbSubDestinationSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DvbSubDestinationSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, DvbSubDestinationSettings> {
    private final String alignment;
    private final String backgroundColor;
    private final Integer backgroundOpacity;
    private final InputLocation font;
    private final String fontColor;
    private final Integer fontOpacity;
    private final Integer fontResolution;
    private final String fontSize;
    private final String outlineColor;
    private final Integer outlineSize;
    private final String shadowColor;
    private final Integer shadowOpacity;
    private final Integer shadowXOffset;
    private final Integer shadowYOffset;
    private final String teletextGridControl;
    private final Integer xPosition;
    private final Integer yPosition;

    private DvbSubDestinationSettings(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.backgroundColor = builder.backgroundColor;
        this.backgroundOpacity = builder.backgroundOpacity;
        this.font = builder.font;
        this.fontColor = builder.fontColor;
        this.fontOpacity = builder.fontOpacity;
        this.fontResolution = builder.fontResolution;
        this.fontSize = builder.fontSize;
        this.outlineColor = builder.outlineColor;
        this.outlineSize = builder.outlineSize;
        this.shadowColor = builder.shadowColor;
        this.shadowOpacity = builder.shadowOpacity;
        this.shadowXOffset = builder.shadowXOffset;
        this.shadowYOffset = builder.shadowYOffset;
        this.teletextGridControl = builder.teletextGridControl;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    public DvbSubDestinationAlignment alignment() {
        return DvbSubDestinationAlignment.fromValue(this.alignment);
    }

    public String alignmentString() {
        return this.alignment;
    }

    public DvbSubDestinationBackgroundColor backgroundColor() {
        return DvbSubDestinationBackgroundColor.fromValue(this.backgroundColor);
    }

    public String backgroundColorString() {
        return this.backgroundColor;
    }

    public Integer backgroundOpacity() {
        return this.backgroundOpacity;
    }

    public InputLocation font() {
        return this.font;
    }

    public DvbSubDestinationFontColor fontColor() {
        return DvbSubDestinationFontColor.fromValue(this.fontColor);
    }

    public String fontColorString() {
        return this.fontColor;
    }

    public Integer fontOpacity() {
        return this.fontOpacity;
    }

    public Integer fontResolution() {
        return this.fontResolution;
    }

    public String fontSize() {
        return this.fontSize;
    }

    public DvbSubDestinationOutlineColor outlineColor() {
        return DvbSubDestinationOutlineColor.fromValue(this.outlineColor);
    }

    public String outlineColorString() {
        return this.outlineColor;
    }

    public Integer outlineSize() {
        return this.outlineSize;
    }

    public DvbSubDestinationShadowColor shadowColor() {
        return DvbSubDestinationShadowColor.fromValue(this.shadowColor);
    }

    public String shadowColorString() {
        return this.shadowColor;
    }

    public Integer shadowOpacity() {
        return this.shadowOpacity;
    }

    public Integer shadowXOffset() {
        return this.shadowXOffset;
    }

    public Integer shadowYOffset() {
        return this.shadowYOffset;
    }

    public DvbSubDestinationTeletextGridControl teletextGridControl() {
        return DvbSubDestinationTeletextGridControl.fromValue(this.teletextGridControl);
    }

    public String teletextGridControlString() {
        return this.teletextGridControl;
    }

    public Integer xPosition() {
        return this.xPosition;
    }

    public Integer yPosition() {
        return this.yPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alignmentString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.font());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontColorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineColorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outlineSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowColorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowXOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.shadowYOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextGridControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.yPosition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSubDestinationSettings)) {
            return false;
        }
        DvbSubDestinationSettings other = (DvbSubDestinationSettings)obj;
        return Objects.equals(this.alignmentString(), other.alignmentString()) && Objects.equals(this.backgroundColorString(), other.backgroundColorString()) && Objects.equals(this.backgroundOpacity(), other.backgroundOpacity()) && Objects.equals(this.font(), other.font()) && Objects.equals(this.fontColorString(), other.fontColorString()) && Objects.equals(this.fontOpacity(), other.fontOpacity()) && Objects.equals(this.fontResolution(), other.fontResolution()) && Objects.equals(this.fontSize(), other.fontSize()) && Objects.equals(this.outlineColorString(), other.outlineColorString()) && Objects.equals(this.outlineSize(), other.outlineSize()) && Objects.equals(this.shadowColorString(), other.shadowColorString()) && Objects.equals(this.shadowOpacity(), other.shadowOpacity()) && Objects.equals(this.shadowXOffset(), other.shadowXOffset()) && Objects.equals(this.shadowYOffset(), other.shadowYOffset()) && Objects.equals(this.teletextGridControlString(), other.teletextGridControlString()) && Objects.equals(this.xPosition(), other.xPosition()) && Objects.equals(this.yPosition(), other.yPosition());
    }

    public String toString() {
        return ToString.builder((String)"DvbSubDestinationSettings").add("Alignment", (Object)this.alignmentString()).add("BackgroundColor", (Object)this.backgroundColorString()).add("BackgroundOpacity", (Object)this.backgroundOpacity()).add("Font", (Object)this.font()).add("FontColor", (Object)this.fontColorString()).add("FontOpacity", (Object)this.fontOpacity()).add("FontResolution", (Object)this.fontResolution()).add("FontSize", (Object)this.fontSize()).add("OutlineColor", (Object)this.outlineColorString()).add("OutlineSize", (Object)this.outlineSize()).add("ShadowColor", (Object)this.shadowColorString()).add("ShadowOpacity", (Object)this.shadowOpacity()).add("ShadowXOffset", (Object)this.shadowXOffset()).add("ShadowYOffset", (Object)this.shadowYOffset()).add("TeletextGridControl", (Object)this.teletextGridControlString()).add("XPosition", (Object)this.xPosition()).add("YPosition", (Object)this.yPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alignment": {
                return Optional.of(clazz.cast(this.alignmentString()));
            }
            case "BackgroundColor": {
                return Optional.of(clazz.cast(this.backgroundColorString()));
            }
            case "BackgroundOpacity": {
                return Optional.of(clazz.cast(this.backgroundOpacity()));
            }
            case "Font": {
                return Optional.of(clazz.cast(this.font()));
            }
            case "FontColor": {
                return Optional.of(clazz.cast(this.fontColorString()));
            }
            case "FontOpacity": {
                return Optional.of(clazz.cast(this.fontOpacity()));
            }
            case "FontResolution": {
                return Optional.of(clazz.cast(this.fontResolution()));
            }
            case "FontSize": {
                return Optional.of(clazz.cast(this.fontSize()));
            }
            case "OutlineColor": {
                return Optional.of(clazz.cast(this.outlineColorString()));
            }
            case "OutlineSize": {
                return Optional.of(clazz.cast(this.outlineSize()));
            }
            case "ShadowColor": {
                return Optional.of(clazz.cast(this.shadowColorString()));
            }
            case "ShadowOpacity": {
                return Optional.of(clazz.cast(this.shadowOpacity()));
            }
            case "ShadowXOffset": {
                return Optional.of(clazz.cast(this.shadowXOffset()));
            }
            case "ShadowYOffset": {
                return Optional.of(clazz.cast(this.shadowYOffset()));
            }
            case "TeletextGridControl": {
                return Optional.of(clazz.cast(this.teletextGridControlString()));
            }
            case "XPosition": {
                return Optional.of(clazz.cast(this.xPosition()));
            }
            case "YPosition": {
                return Optional.of(clazz.cast(this.yPosition()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DvbSubDestinationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String alignment;
        private String backgroundColor;
        private Integer backgroundOpacity;
        private InputLocation font;
        private String fontColor;
        private Integer fontOpacity;
        private Integer fontResolution;
        private String fontSize;
        private String outlineColor;
        private Integer outlineSize;
        private String shadowColor;
        private Integer shadowOpacity;
        private Integer shadowXOffset;
        private Integer shadowYOffset;
        private String teletextGridControl;
        private Integer xPosition;
        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSubDestinationSettings model) {
            this.alignment(model.alignment);
            this.backgroundColor(model.backgroundColor);
            this.backgroundOpacity(model.backgroundOpacity);
            this.font(model.font);
            this.fontColor(model.fontColor);
            this.fontOpacity(model.fontOpacity);
            this.fontResolution(model.fontResolution);
            this.fontSize(model.fontSize);
            this.outlineColor(model.outlineColor);
            this.outlineSize(model.outlineSize);
            this.shadowColor(model.shadowColor);
            this.shadowOpacity(model.shadowOpacity);
            this.shadowXOffset(model.shadowXOffset);
            this.shadowYOffset(model.shadowYOffset);
            this.teletextGridControl(model.teletextGridControl);
            this.xPosition(model.xPosition);
            this.yPosition(model.yPosition);
        }

        public final String getAlignment() {
            return this.alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(DvbSubDestinationAlignment alignment) {
            this.alignment(alignment.toString());
            return this;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public final Builder backgroundColor(DvbSubDestinationBackgroundColor backgroundColor) {
            this.backgroundColor(backgroundColor.toString());
            return this;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public final Integer getBackgroundOpacity() {
            return this.backgroundOpacity;
        }

        @Override
        public final Builder backgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
            return this;
        }

        public final void setBackgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
        }

        public final InputLocation.Builder getFont() {
            return this.font != null ? this.font.toBuilder() : null;
        }

        @Override
        public final Builder font(InputLocation font) {
            this.font = font;
            return this;
        }

        public final void setFont(InputLocation.BuilderImpl font) {
            this.font = font != null ? font.build() : null;
        }

        public final String getFontColor() {
            return this.fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        @Override
        public final Builder fontColor(DvbSubDestinationFontColor fontColor) {
            this.fontColor(fontColor.toString());
            return this;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public final Integer getFontOpacity() {
            return this.fontOpacity;
        }

        @Override
        public final Builder fontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
            return this;
        }

        public final void setFontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
        }

        public final Integer getFontResolution() {
            return this.fontResolution;
        }

        @Override
        public final Builder fontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
            return this;
        }

        public final void setFontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
        }

        public final String getFontSize() {
            return this.fontSize;
        }

        @Override
        public final Builder fontSize(String fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final void setFontSize(String fontSize) {
            this.fontSize = fontSize;
        }

        public final String getOutlineColor() {
            return this.outlineColor;
        }

        @Override
        public final Builder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        @Override
        public final Builder outlineColor(DvbSubDestinationOutlineColor outlineColor) {
            this.outlineColor(outlineColor.toString());
            return this;
        }

        public final void setOutlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
        }

        public final Integer getOutlineSize() {
            return this.outlineSize;
        }

        @Override
        public final Builder outlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
            return this;
        }

        public final void setOutlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
        }

        public final String getShadowColor() {
            return this.shadowColor;
        }

        @Override
        public final Builder shadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
            return this;
        }

        @Override
        public final Builder shadowColor(DvbSubDestinationShadowColor shadowColor) {
            this.shadowColor(shadowColor.toString());
            return this;
        }

        public final void setShadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
        }

        public final Integer getShadowOpacity() {
            return this.shadowOpacity;
        }

        @Override
        public final Builder shadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            return this;
        }

        public final void setShadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
        }

        public final Integer getShadowXOffset() {
            return this.shadowXOffset;
        }

        @Override
        public final Builder shadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
            return this;
        }

        public final void setShadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
        }

        public final Integer getShadowYOffset() {
            return this.shadowYOffset;
        }

        @Override
        public final Builder shadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
            return this;
        }

        public final void setShadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
        }

        public final String getTeletextGridControl() {
            return this.teletextGridControl;
        }

        @Override
        public final Builder teletextGridControl(String teletextGridControl) {
            this.teletextGridControl = teletextGridControl;
            return this;
        }

        @Override
        public final Builder teletextGridControl(DvbSubDestinationTeletextGridControl teletextGridControl) {
            this.teletextGridControl(teletextGridControl.toString());
            return this;
        }

        public final void setTeletextGridControl(String teletextGridControl) {
            this.teletextGridControl = teletextGridControl;
        }

        public final Integer getXPosition() {
            return this.xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        public final Integer getYPosition() {
            return this.yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        public DvbSubDestinationSettings build() {
            return new DvbSubDestinationSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DvbSubDestinationSettings> {
        public Builder alignment(String var1);

        public Builder alignment(DvbSubDestinationAlignment var1);

        public Builder backgroundColor(String var1);

        public Builder backgroundColor(DvbSubDestinationBackgroundColor var1);

        public Builder backgroundOpacity(Integer var1);

        public Builder font(InputLocation var1);

        default public Builder font(Consumer<InputLocation.Builder> font) {
            return this.font((InputLocation)((InputLocation.Builder)InputLocation.builder().apply(font)).build());
        }

        public Builder fontColor(String var1);

        public Builder fontColor(DvbSubDestinationFontColor var1);

        public Builder fontOpacity(Integer var1);

        public Builder fontResolution(Integer var1);

        public Builder fontSize(String var1);

        public Builder outlineColor(String var1);

        public Builder outlineColor(DvbSubDestinationOutlineColor var1);

        public Builder outlineSize(Integer var1);

        public Builder shadowColor(String var1);

        public Builder shadowColor(DvbSubDestinationShadowColor var1);

        public Builder shadowOpacity(Integer var1);

        public Builder shadowXOffset(Integer var1);

        public Builder shadowYOffset(Integer var1);

        public Builder teletextGridControl(String var1);

        public Builder teletextGridControl(DvbSubDestinationTeletextGridControl var1);

        public Builder xPosition(Integer var1);

        public Builder yPosition(Integer var1);
    }
}

