/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.transform.DvbNitSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DvbNitSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, DvbNitSettings> {
    private final Integer networkId;
    private final String networkName;
    private final Integer repInterval;

    private DvbNitSettings(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.networkName = builder.networkName;
        this.repInterval = builder.repInterval;
    }

    public Integer networkId() {
        return this.networkId;
    }

    public String networkName() {
        return this.networkName;
    }

    public Integer repInterval() {
        return this.repInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repInterval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbNitSettings)) {
            return false;
        }
        DvbNitSettings other = (DvbNitSettings)obj;
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.networkName(), other.networkName()) && Objects.equals(this.repInterval(), other.repInterval());
    }

    public String toString() {
        return ToString.builder((String)"DvbNitSettings").add("NetworkId", (Object)this.networkId()).add("NetworkName", (Object)this.networkName()).add("RepInterval", (Object)this.repInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.of(clazz.cast(this.networkId()));
            }
            case "NetworkName": {
                return Optional.of(clazz.cast(this.networkName()));
            }
            case "RepInterval": {
                return Optional.of(clazz.cast(this.repInterval()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DvbNitSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer networkId;
        private String networkName;
        private Integer repInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbNitSettings model) {
            this.networkId(model.networkId);
            this.networkName(model.networkName);
            this.repInterval(model.repInterval);
        }

        public final Integer getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(Integer networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(Integer networkId) {
            this.networkId = networkId;
        }

        public final String getNetworkName() {
            return this.networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        public final Integer getRepInterval() {
            return this.repInterval;
        }

        @Override
        public final Builder repInterval(Integer repInterval) {
            this.repInterval = repInterval;
            return this;
        }

        public final void setRepInterval(Integer repInterval) {
            this.repInterval = repInterval;
        }

        public DvbNitSettings build() {
            return new DvbNitSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DvbNitSettings> {
        public Builder networkId(Integer var1);

        public Builder networkName(String var1);

        public Builder repInterval(Integer var1);
    }
}

