/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.medialive.model.InputWhitelistRule;
import software.amazon.awssdk.services.medialive.model.ListOfInputWhitelistRuleCopier;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInputSecurityGroupResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DescribeInputSecurityGroupResponse> {
    private final String arn;
    private final String id;
    private final List<InputWhitelistRule> whitelistRules;

    private DescribeInputSecurityGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.whitelistRules = builder.whitelistRules;
    }

    public String arn() {
        return this.arn;
    }

    public String id() {
        return this.id;
    }

    public List<InputWhitelistRule> whitelistRules() {
        return this.whitelistRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputSecurityGroupResponse)) {
            return false;
        }
        DescribeInputSecurityGroupResponse other = (DescribeInputSecurityGroupResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.whitelistRules(), other.whitelistRules());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInputSecurityGroupResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("WhitelistRules", this.whitelistRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "WhitelistRules": {
                return Optional.of(clazz.cast(this.whitelistRules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private List<InputWhitelistRule> whitelistRules;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputSecurityGroupResponse model) {
            this.arn(model.arn);
            this.id(model.id);
            this.whitelistRules(model.whitelistRules);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<InputWhitelistRule.Builder> getWhitelistRules() {
            return this.whitelistRules != null ? (Collection)this.whitelistRules.stream().map(InputWhitelistRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder whitelistRules(Collection<InputWhitelistRule> whitelistRules) {
            this.whitelistRules = ListOfInputWhitelistRuleCopier.copy(whitelistRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelistRules(InputWhitelistRule ... whitelistRules) {
            this.whitelistRules(Arrays.asList(whitelistRules));
            return this;
        }

        public final void setWhitelistRules(Collection<InputWhitelistRule.BuilderImpl> whitelistRules) {
            this.whitelistRules = ListOfInputWhitelistRuleCopier.copyFromBuilder(whitelistRules);
        }

        @Override
        public DescribeInputSecurityGroupResponse build() {
            return new DescribeInputSecurityGroupResponse(this);
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    CopyableBuilder<Builder, DescribeInputSecurityGroupResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder whitelistRules(Collection<InputWhitelistRule> var1);

        public Builder whitelistRules(InputWhitelistRule ... var1);
    }
}

