/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioSelectorSettings;
import software.amazon.awssdk.services.medialive.transform.AudioSelectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AudioSelector
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioSelector> {
    private final String name;
    private final AudioSelectorSettings selectorSettings;

    private AudioSelector(BuilderImpl builder) {
        this.name = builder.name;
        this.selectorSettings = builder.selectorSettings;
    }

    public String name() {
        return this.name;
    }

    public AudioSelectorSettings selectorSettings() {
        return this.selectorSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelector)) {
            return false;
        }
        AudioSelector other = (AudioSelector)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.selectorSettings(), other.selectorSettings());
    }

    public String toString() {
        return ToString.builder((String)"AudioSelector").add("Name", (Object)this.name()).add("SelectorSettings", (Object)this.selectorSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SelectorSettings": {
                return Optional.of(clazz.cast(this.selectorSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private AudioSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelector model) {
            this.name(model.name);
            this.selectorSettings(model.selectorSettings);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final AudioSelectorSettings.Builder getSelectorSettings() {
            return this.selectorSettings != null ? this.selectorSettings.toBuilder() : null;
        }

        @Override
        public final Builder selectorSettings(AudioSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        public final void setSelectorSettings(AudioSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        public AudioSelector build() {
            return new AudioSelector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioSelector> {
        public Builder name(String var1);

        public Builder selectorSettings(AudioSelectorSettings var1);

        default public Builder selectorSettings(Consumer<AudioSelectorSettings.Builder> selectorSettings) {
            return this.selectorSettings((AudioSelectorSettings)((AudioSelectorSettings.Builder)AudioSelectorSettings.builder().apply(selectorSettings)).build());
        }
    }
}

