/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.transform.ArchiveGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ArchiveGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, ArchiveGroupSettings> {
    private final OutputLocationRef destination;
    private final Integer rolloverInterval;

    private ArchiveGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.rolloverInterval = builder.rolloverInterval;
    }

    public OutputLocationRef destination() {
        return this.destination;
    }

    public Integer rolloverInterval() {
        return this.rolloverInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolloverInterval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveGroupSettings)) {
            return false;
        }
        ArchiveGroupSettings other = (ArchiveGroupSettings)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.rolloverInterval(), other.rolloverInterval());
    }

    public String toString() {
        return ToString.builder((String)"ArchiveGroupSettings").add("Destination", (Object)this.destination()).add("RolloverInterval", (Object)this.rolloverInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
            case "RolloverInterval": {
                return Optional.of(clazz.cast(this.rolloverInterval()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArchiveGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private OutputLocationRef destination;
        private Integer rolloverInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveGroupSettings model) {
            this.destination(model.destination);
            this.rolloverInterval(model.rolloverInterval);
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Integer getRolloverInterval() {
            return this.rolloverInterval;
        }

        @Override
        public final Builder rolloverInterval(Integer rolloverInterval) {
            this.rolloverInterval = rolloverInterval;
            return this;
        }

        public final void setRolloverInterval(Integer rolloverInterval) {
            this.rolloverInterval = rolloverInterval;
        }

        public ArchiveGroupSettings build() {
            return new ArchiveGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ArchiveGroupSettings> {
        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().apply(destination)).build());
        }

        public Builder rolloverInterval(Integer var1);
    }
}

