/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AacCodingMode;
import software.amazon.awssdk.services.medialive.model.AacInputType;
import software.amazon.awssdk.services.medialive.model.AacProfile;
import software.amazon.awssdk.services.medialive.model.AacRateControlMode;
import software.amazon.awssdk.services.medialive.model.AacRawFormat;
import software.amazon.awssdk.services.medialive.model.AacSpec;
import software.amazon.awssdk.services.medialive.model.AacVbrQuality;
import software.amazon.awssdk.services.medialive.transform.AacSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AacSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AacSettings> {
    private final Double bitrate;
    private final String codingMode;
    private final String inputType;
    private final String profile;
    private final String rateControlMode;
    private final String rawFormat;
    private final Double sampleRate;
    private final String spec;
    private final String vbrQuality;

    private AacSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.codingMode = builder.codingMode;
        this.inputType = builder.inputType;
        this.profile = builder.profile;
        this.rateControlMode = builder.rateControlMode;
        this.rawFormat = builder.rawFormat;
        this.sampleRate = builder.sampleRate;
        this.spec = builder.spec;
        this.vbrQuality = builder.vbrQuality;
    }

    public Double bitrate() {
        return this.bitrate;
    }

    public AacCodingMode codingMode() {
        return AacCodingMode.fromValue(this.codingMode);
    }

    public String codingModeString() {
        return this.codingMode;
    }

    public AacInputType inputType() {
        return AacInputType.fromValue(this.inputType);
    }

    public String inputTypeString() {
        return this.inputType;
    }

    public AacProfile profile() {
        return AacProfile.fromValue(this.profile);
    }

    public String profileString() {
        return this.profile;
    }

    public AacRateControlMode rateControlMode() {
        return AacRateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeString() {
        return this.rateControlMode;
    }

    public AacRawFormat rawFormat() {
        return AacRawFormat.fromValue(this.rawFormat);
    }

    public String rawFormatString() {
        return this.rawFormat;
    }

    public Double sampleRate() {
        return this.sampleRate;
    }

    public AacSpec spec() {
        return AacSpec.fromValue(this.spec);
    }

    public String specString() {
        return this.spec;
    }

    public AacVbrQuality vbrQuality() {
        return AacVbrQuality.fromValue(this.vbrQuality);
    }

    public String vbrQualityString() {
        return this.vbrQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawFormatString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.specString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vbrQualityString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AacSettings)) {
            return false;
        }
        AacSettings other = (AacSettings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codingModeString(), other.codingModeString()) && Objects.equals(this.inputTypeString(), other.inputTypeString()) && Objects.equals(this.profileString(), other.profileString()) && Objects.equals(this.rateControlModeString(), other.rateControlModeString()) && Objects.equals(this.rawFormatString(), other.rawFormatString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.specString(), other.specString()) && Objects.equals(this.vbrQualityString(), other.vbrQualityString());
    }

    public String toString() {
        return ToString.builder((String)"AacSettings").add("Bitrate", (Object)this.bitrate()).add("CodingMode", (Object)this.codingModeString()).add("InputType", (Object)this.inputTypeString()).add("Profile", (Object)this.profileString()).add("RateControlMode", (Object)this.rateControlModeString()).add("RawFormat", (Object)this.rawFormatString()).add("SampleRate", (Object)this.sampleRate()).add("Spec", (Object)this.specString()).add("VbrQuality", (Object)this.vbrQualityString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.of(clazz.cast(this.bitrate()));
            }
            case "CodingMode": {
                return Optional.of(clazz.cast(this.codingModeString()));
            }
            case "InputType": {
                return Optional.of(clazz.cast(this.inputTypeString()));
            }
            case "Profile": {
                return Optional.of(clazz.cast(this.profileString()));
            }
            case "RateControlMode": {
                return Optional.of(clazz.cast(this.rateControlModeString()));
            }
            case "RawFormat": {
                return Optional.of(clazz.cast(this.rawFormatString()));
            }
            case "SampleRate": {
                return Optional.of(clazz.cast(this.sampleRate()));
            }
            case "Spec": {
                return Optional.of(clazz.cast(this.specString()));
            }
            case "VbrQuality": {
                return Optional.of(clazz.cast(this.vbrQualityString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AacSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bitrate;
        private String codingMode;
        private String inputType;
        private String profile;
        private String rateControlMode;
        private String rawFormat;
        private Double sampleRate;
        private String spec;
        private String vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(AacSettings model) {
            this.bitrate(model.bitrate);
            this.codingMode(model.codingMode);
            this.inputType(model.inputType);
            this.profile(model.profile);
            this.rateControlMode(model.rateControlMode);
            this.rawFormat(model.rawFormat);
            this.sampleRate(model.sampleRate);
            this.spec(model.spec);
            this.vbrQuality(model.vbrQuality);
        }

        public final Double getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(AacCodingMode codingMode) {
            this.codingMode(codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final String getInputType() {
            return this.inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(AacInputType inputType) {
            this.inputType(inputType.toString());
            return this;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        public final String getProfile() {
            return this.profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(AacProfile profile) {
            this.profile(profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(AacRateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getRawFormat() {
            return this.rawFormat;
        }

        @Override
        public final Builder rawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
            return this;
        }

        @Override
        public final Builder rawFormat(AacRawFormat rawFormat) {
            this.rawFormat(rawFormat.toString());
            return this;
        }

        public final void setRawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
        }

        public final Double getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final String getSpec() {
            return this.spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        @Override
        public final Builder spec(AacSpec spec) {
            this.spec(spec.toString());
            return this;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        public final String getVbrQuality() {
            return this.vbrQuality;
        }

        @Override
        public final Builder vbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        @Override
        public final Builder vbrQuality(AacVbrQuality vbrQuality) {
            this.vbrQuality(vbrQuality.toString());
            return this;
        }

        public final void setVbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        public AacSettings build() {
            return new AacSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AacSettings> {
        public Builder bitrate(Double var1);

        public Builder codingMode(String var1);

        public Builder codingMode(AacCodingMode var1);

        public Builder inputType(String var1);

        public Builder inputType(AacInputType var1);

        public Builder profile(String var1);

        public Builder profile(AacProfile var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(AacRateControlMode var1);

        public Builder rawFormat(String var1);

        public Builder rawFormat(AacRawFormat var1);

        public Builder sampleRate(Double var1);

        public Builder spec(String var1);

        public Builder spec(AacSpec var1);

        public Builder vbrQuality(String var1);

        public Builder vbrQuality(AacVbrQuality var1);
    }
}

