/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.VideoSelector;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VideoSelectorMarshaller {
    private static final MarshallingInfo<String> COLORSPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpace").isBinary(false).build();
    private static final MarshallingInfo<String> COLORSPACEUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpaceUsage").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SELECTORSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("selectorSettings").isBinary(false).build();
    private static final VideoSelectorMarshaller INSTANCE = new VideoSelectorMarshaller();

    private VideoSelectorMarshaller() {
    }

    public static VideoSelectorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoSelector videoSelector, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)videoSelector, (String)"videoSelector");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)videoSelector.colorSpaceAsString(), COLORSPACE_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.colorSpaceUsageAsString(), COLORSPACEUSAGE_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.selectorSettings(), SELECTORSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

