/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.UdpOutputSettings;
import software.amazon.awssdk.services.medialive.transform.FecOutputSettingsUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.OutputLocationRefUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.UdpContainerSettingsUnmarshaller;

public class UdpOutputSettingsUnmarshaller
implements Unmarshaller<UdpOutputSettings, JsonUnmarshallerContext> {
    private static final UdpOutputSettingsUnmarshaller INSTANCE = new UdpOutputSettingsUnmarshaller();

    public UdpOutputSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        UdpOutputSettings.Builder udpOutputSettingsBuilder = UdpOutputSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bufferMsec", targetDepth)) {
                    context.nextToken();
                    udpOutputSettingsBuilder.bufferMsec((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("containerSettings", targetDepth)) {
                    context.nextToken();
                    udpOutputSettingsBuilder.containerSettings(UdpContainerSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("destination", targetDepth)) {
                    context.nextToken();
                    udpOutputSettingsBuilder.destination(OutputLocationRefUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("fecOutputSettings", targetDepth)) {
                    context.nextToken();
                    udpOutputSettingsBuilder.fecOutputSettings(FecOutputSettingsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (UdpOutputSettings)udpOutputSettingsBuilder.build();
    }

    public static UdpOutputSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

