/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.UdpOutputSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UdpOutputSettingsMarshaller {
    private static final MarshallingInfo<Integer> BUFFERMSEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bufferMsec").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONTAINERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FECOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fecOutputSettings").isBinary(false).build();
    private static final UdpOutputSettingsMarshaller INSTANCE = new UdpOutputSettingsMarshaller();

    private UdpOutputSettingsMarshaller() {
    }

    public static UdpOutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UdpOutputSettings udpOutputSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)udpOutputSettings, (String)"udpOutputSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)udpOutputSettings.bufferMsec(), BUFFERMSEC_BINDING);
            protocolMarshaller.marshall((Object)udpOutputSettings.containerSettings(), CONTAINERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)udpOutputSettings.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)udpOutputSettings.fecOutputSettings(), FECOUTPUTSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

