/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.StandardHlsSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StandardHlsSettingsMarshaller {
    private static final MarshallingInfo<String> AUDIORENDITIONSETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioRenditionSets").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> M3U8SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("m3u8Settings").isBinary(false).build();
    private static final StandardHlsSettingsMarshaller INSTANCE = new StandardHlsSettingsMarshaller();

    private StandardHlsSettingsMarshaller() {
    }

    public static StandardHlsSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StandardHlsSettings standardHlsSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)standardHlsSettings, (String)"standardHlsSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)standardHlsSettings.audioRenditionSets(), AUDIORENDITIONSETS_BINDING);
            protocolMarshaller.marshall((Object)standardHlsSettings.m3u8Settings(), M3U8SETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

