/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.Scte35SpliceInsert;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Scte35SpliceInsertMarshaller {
    private static final MarshallingInfo<Integer> ADAVAILOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adAvailOffset").isBinary(false).build();
    private static final MarshallingInfo<String> NOREGIONALBLACKOUTFLAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("noRegionalBlackoutFlag").isBinary(false).build();
    private static final MarshallingInfo<String> WEBDELIVERYALLOWEDFLAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("webDeliveryAllowedFlag").isBinary(false).build();
    private static final Scte35SpliceInsertMarshaller INSTANCE = new Scte35SpliceInsertMarshaller();

    private Scte35SpliceInsertMarshaller() {
    }

    public static Scte35SpliceInsertMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Scte35SpliceInsert scte35SpliceInsert, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)scte35SpliceInsert, (String)"scte35SpliceInsert");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)scte35SpliceInsert.adAvailOffset(), ADAVAILOFFSET_BINDING);
            protocolMarshaller.marshall((Object)scte35SpliceInsert.noRegionalBlackoutFlagAsString(), NOREGIONALBLACKOUTFLAG_BINDING);
            protocolMarshaller.marshall((Object)scte35SpliceInsert.webDeliveryAllowedFlagAsString(), WEBDELIVERYALLOWEDFLAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

