/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.OutputSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ARCHIVEOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("archiveOutputSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HLSOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsOutputSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MSSMOOTHOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("msSmoothOutputSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> UDPOUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("udpOutputSettings").isBinary(false).build();
    private static final OutputSettingsMarshaller INSTANCE = new OutputSettingsMarshaller();

    private OutputSettingsMarshaller() {
    }

    public static OutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputSettings outputSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputSettings, (String)"outputSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputSettings.archiveOutputSettings(), ARCHIVEOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputSettings.hlsOutputSettings(), HLSOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputSettings.msSmoothOutputSettings(), MSSMOOTHOUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)outputSettings.udpOutputSettings(), UDPOUTPUTSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

