/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputLocationRefMarshaller {
    private static final MarshallingInfo<String> DESTINATIONREFID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationRefId").isBinary(false).build();
    private static final OutputLocationRefMarshaller INSTANCE = new OutputLocationRefMarshaller();

    private OutputLocationRefMarshaller() {
    }

    public static OutputLocationRefMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputLocationRef outputLocationRef, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputLocationRef, (String)"outputLocationRef");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputLocationRef.destinationRefId(), DESTINATIONREFID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

