/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputDestinationMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<List> SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("settings").isBinary(false).build();
    private static final OutputDestinationMarshaller INSTANCE = new OutputDestinationMarshaller();

    private OutputDestinationMarshaller() {
    }

    public static OutputDestinationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputDestination outputDestination, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputDestination, (String)"outputDestination");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputDestination.id(), ID_BINDING);
            protocolMarshaller.marshall(outputDestination.settings(), SETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

