/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.NetworkInputSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NetworkInputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> HLSINPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsInputSettings").isBinary(false).build();
    private static final MarshallingInfo<String> SERVERVALIDATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverValidation").isBinary(false).build();
    private static final NetworkInputSettingsMarshaller INSTANCE = new NetworkInputSettingsMarshaller();

    private NetworkInputSettingsMarshaller() {
    }

    public static NetworkInputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NetworkInputSettings networkInputSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)networkInputSettings, (String)"networkInputSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)networkInputSettings.hlsInputSettings(), HLSINPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)networkInputSettings.serverValidationAsString(), SERVERVALIDATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

