/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.InputSourceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputSourceRequestMarshaller {
    private static final MarshallingInfo<String> PASSWORDPARAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passwordParam").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").isBinary(false).build();
    private static final InputSourceRequestMarshaller INSTANCE = new InputSourceRequestMarshaller();

    private InputSourceRequestMarshaller() {
    }

    public static InputSourceRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputSourceRequest inputSourceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputSourceRequest, (String)"inputSourceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputSourceRequest.passwordParam(), PASSWORDPARAM_BINDING);
            protocolMarshaller.marshall((Object)inputSourceRequest.url(), URL_BINDING);
            protocolMarshaller.marshall((Object)inputSourceRequest.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

