/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.InputSecurityGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputSecurityGroupMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<List> WHITELISTRULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitelistRules").isBinary(false).build();
    private static final InputSecurityGroupMarshaller INSTANCE = new InputSecurityGroupMarshaller();

    private InputSecurityGroupMarshaller() {
    }

    public static InputSecurityGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputSecurityGroup inputSecurityGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputSecurityGroup, (String)"inputSecurityGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputSecurityGroup.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)inputSecurityGroup.id(), ID_BINDING);
            protocolMarshaller.marshall(inputSecurityGroup.whitelistRules(), WHITELISTRULES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

