/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.InputDestinationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputDestinationRequestMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").isBinary(false).build();
    private static final InputDestinationRequestMarshaller INSTANCE = new InputDestinationRequestMarshaller();

    private InputDestinationRequestMarshaller() {
    }

    public static InputDestinationRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputDestinationRequest inputDestinationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputDestinationRequest, (String)"inputDestinationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputDestinationRequest.streamName(), STREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

