/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.InputAttachment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputAttachmentMarshaller {
    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputSettings").isBinary(false).build();
    private static final InputAttachmentMarshaller INSTANCE = new InputAttachmentMarshaller();

    private InputAttachmentMarshaller() {
    }

    public static InputAttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputAttachment inputAttachment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputAttachment, (String)"inputAttachment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputAttachment.inputId(), INPUTID_BINDING);
            protocolMarshaller.marshall((Object)inputAttachment.inputSettings(), INPUTSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

