/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.HlsWebdavSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsWebdavSettingsMarshaller {
    private static final MarshallingInfo<Integer> CONNECTIONRETRYINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionRetryInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> FILECACHEDURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filecacheDuration").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPTRANSFERMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpTransferMode").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numRetries").isBinary(false).build();
    private static final MarshallingInfo<Integer> RESTARTDELAY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("restartDelay").isBinary(false).build();
    private static final HlsWebdavSettingsMarshaller INSTANCE = new HlsWebdavSettingsMarshaller();

    private HlsWebdavSettingsMarshaller() {
    }

    public static HlsWebdavSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsWebdavSettings hlsWebdavSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsWebdavSettings, (String)"hlsWebdavSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsWebdavSettings.connectionRetryInterval(), CONNECTIONRETRYINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)hlsWebdavSettings.filecacheDuration(), FILECACHEDURATION_BINDING);
            protocolMarshaller.marshall((Object)hlsWebdavSettings.httpTransferModeAsString(), HTTPTRANSFERMODE_BINDING);
            protocolMarshaller.marshall((Object)hlsWebdavSettings.numRetries(), NUMRETRIES_BINDING);
            protocolMarshaller.marshall((Object)hlsWebdavSettings.restartDelay(), RESTARTDELAY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

