/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.HlsSettings;
import software.amazon.awssdk.services.medialive.transform.AudioOnlyHlsSettingsUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.StandardHlsSettingsUnmarshaller;

public class HlsSettingsUnmarshaller
implements Unmarshaller<HlsSettings, JsonUnmarshallerContext> {
    private static final HlsSettingsUnmarshaller INSTANCE = new HlsSettingsUnmarshaller();

    public HlsSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        HlsSettings.Builder hlsSettingsBuilder = HlsSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audioOnlyHlsSettings", targetDepth)) {
                    context.nextToken();
                    hlsSettingsBuilder.audioOnlyHlsSettings(AudioOnlyHlsSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("standardHlsSettings", targetDepth)) {
                    context.nextToken();
                    hlsSettingsBuilder.standardHlsSettings(StandardHlsSettingsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HlsSettings)hlsSettingsBuilder.build();
    }

    public static HlsSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

