/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.HlsMediaStoreSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsMediaStoreSettingsMarshaller {
    private static final MarshallingInfo<Integer> CONNECTIONRETRYINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionRetryInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> FILECACHEDURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filecacheDuration").isBinary(false).build();
    private static final MarshallingInfo<String> MEDIASTORESTORAGECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaStoreStorageClass").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numRetries").isBinary(false).build();
    private static final MarshallingInfo<Integer> RESTARTDELAY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("restartDelay").isBinary(false).build();
    private static final HlsMediaStoreSettingsMarshaller INSTANCE = new HlsMediaStoreSettingsMarshaller();

    private HlsMediaStoreSettingsMarshaller() {
    }

    public static HlsMediaStoreSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsMediaStoreSettings hlsMediaStoreSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsMediaStoreSettings, (String)"hlsMediaStoreSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsMediaStoreSettings.connectionRetryInterval(), CONNECTIONRETRYINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)hlsMediaStoreSettings.filecacheDuration(), FILECACHEDURATION_BINDING);
            protocolMarshaller.marshall((Object)hlsMediaStoreSettings.mediaStoreStorageClassAsString(), MEDIASTORESTORAGECLASS_BINDING);
            protocolMarshaller.marshall((Object)hlsMediaStoreSettings.numRetries(), NUMRETRIES_BINDING);
            protocolMarshaller.marshall((Object)hlsMediaStoreSettings.restartDelay(), RESTARTDELAY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

