/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.HlsInputSettings;

public class HlsInputSettingsUnmarshaller
implements Unmarshaller<HlsInputSettings, JsonUnmarshallerContext> {
    private static final HlsInputSettingsUnmarshaller INSTANCE = new HlsInputSettingsUnmarshaller();

    public HlsInputSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        HlsInputSettings.Builder hlsInputSettingsBuilder = HlsInputSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bandwidth", targetDepth)) {
                    context.nextToken();
                    hlsInputSettingsBuilder.bandwidth((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("bufferSegments", targetDepth)) {
                    context.nextToken();
                    hlsInputSettingsBuilder.bufferSegments((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("retries", targetDepth)) {
                    context.nextToken();
                    hlsInputSettingsBuilder.retries((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("retryInterval", targetDepth)) {
                    context.nextToken();
                    hlsInputSettingsBuilder.retryInterval((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HlsInputSettings)hlsInputSettingsBuilder.build();
    }

    public static HlsInputSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

