/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.HlsInputSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsInputSettingsMarshaller {
    private static final MarshallingInfo<Integer> BANDWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bandwidth").isBinary(false).build();
    private static final MarshallingInfo<Integer> BUFFERSEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bufferSegments").isBinary(false).build();
    private static final MarshallingInfo<Integer> RETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retries").isBinary(false).build();
    private static final MarshallingInfo<Integer> RETRYINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retryInterval").isBinary(false).build();
    private static final HlsInputSettingsMarshaller INSTANCE = new HlsInputSettingsMarshaller();

    private HlsInputSettingsMarshaller() {
    }

    public static HlsInputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsInputSettings hlsInputSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsInputSettings, (String)"hlsInputSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsInputSettings.bandwidth(), BANDWIDTH_BINDING);
            protocolMarshaller.marshall((Object)hlsInputSettings.bufferSegments(), BUFFERSEGMENTS_BINDING);
            protocolMarshaller.marshall((Object)hlsInputSettings.retries(), RETRIES_BINDING);
            protocolMarshaller.marshall((Object)hlsInputSettings.retryInterval(), RETRYINTERVAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

