/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsGroupSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsGroupSettingsMarshaller {
    private static final MarshallingInfo<List> ADMARKERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adMarkers").isBinary(false).build();
    private static final MarshallingInfo<String> BASEURLCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseUrlContent").isBinary(false).build();
    private static final MarshallingInfo<String> BASEURLMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseUrlManifest").isBinary(false).build();
    private static final MarshallingInfo<List> CAPTIONLANGUAGEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionLanguageMappings").isBinary(false).build();
    private static final MarshallingInfo<String> CAPTIONLANGUAGESETTING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionLanguageSetting").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTCACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCache").isBinary(false).build();
    private static final MarshallingInfo<String> CODECSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSpecification").isBinary(false).build();
    private static final MarshallingInfo<String> CONSTANTIV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("constantIv").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final MarshallingInfo<String> DIRECTORYSTRUCTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("directoryStructure").isBinary(false).build();
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HLSCDNSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsCdnSettings").isBinary(false).build();
    private static final MarshallingInfo<Integer> INDEXNSEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("indexNSegments").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTLOSSACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputLossAction").isBinary(false).build();
    private static final MarshallingInfo<String> IVINMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ivInManifest").isBinary(false).build();
    private static final MarshallingInfo<String> IVSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ivSource").isBinary(false).build();
    private static final MarshallingInfo<Integer> KEEPSEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keepSegments").isBinary(false).build();
    private static final MarshallingInfo<String> KEYFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyFormat").isBinary(false).build();
    private static final MarshallingInfo<String> KEYFORMATVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyFormatVersions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KEYPROVIDERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyProviderSettings").isBinary(false).build();
    private static final MarshallingInfo<String> MANIFESTCOMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestCompression").isBinary(false).build();
    private static final MarshallingInfo<String> MANIFESTDURATIONFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestDurationFormat").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINSEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minSegmentLength").isBinary(false).build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mode").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputSelection").isBinary(false).build();
    private static final MarshallingInfo<String> PROGRAMDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programDateTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> PROGRAMDATETIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programDateTimePeriod").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentLength").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTATIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentationMode").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTSPERSUBDIRECTORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentsPerSubdirectory").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMINFRESOLUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamInfResolution").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEDMETADATAID3FRAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataId3Frame").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEDMETADATAID3PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataId3Period").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMESTAMPDELTAMILLISECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestampDeltaMilliseconds").isBinary(false).build();
    private static final MarshallingInfo<String> TSFILEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tsFileMode").isBinary(false).build();
    private static final HlsGroupSettingsMarshaller INSTANCE = new HlsGroupSettingsMarshaller();

    private HlsGroupSettingsMarshaller() {
    }

    public static HlsGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsGroupSettings hlsGroupSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsGroupSettings, (String)"hlsGroupSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(hlsGroupSettings.adMarkersAsStrings(), ADMARKERS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.baseUrlContent(), BASEURLCONTENT_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.baseUrlManifest(), BASEURLMANIFEST_BINDING);
            protocolMarshaller.marshall(hlsGroupSettings.captionLanguageMappings(), CAPTIONLANGUAGEMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.captionLanguageSettingAsString(), CAPTIONLANGUAGESETTING_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.clientCacheAsString(), CLIENTCACHE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.codecSpecificationAsString(), CODECSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.constantIv(), CONSTANTIV_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.directoryStructureAsString(), DIRECTORYSTRUCTURE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.encryptionTypeAsString(), ENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.hlsCdnSettings(), HLSCDNSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.indexNSegments(), INDEXNSEGMENTS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.inputLossActionAsString(), INPUTLOSSACTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.ivInManifestAsString(), IVINMANIFEST_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.ivSourceAsString(), IVSOURCE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.keepSegments(), KEEPSEGMENTS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.keyFormat(), KEYFORMAT_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.keyFormatVersions(), KEYFORMATVERSIONS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.keyProviderSettings(), KEYPROVIDERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.manifestCompressionAsString(), MANIFESTCOMPRESSION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.manifestDurationFormatAsString(), MANIFESTDURATIONFORMAT_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.minSegmentLength(), MINSEGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.modeAsString(), MODE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.outputSelectionAsString(), OUTPUTSELECTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.programDateTimeAsString(), PROGRAMDATETIME_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.programDateTimePeriod(), PROGRAMDATETIMEPERIOD_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentLength(), SEGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentationModeAsString(), SEGMENTATIONMODE_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.segmentsPerSubdirectory(), SEGMENTSPERSUBDIRECTORY_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.streamInfResolutionAsString(), STREAMINFRESOLUTION_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timedMetadataId3FrameAsString(), TIMEDMETADATAID3FRAME_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timedMetadataId3Period(), TIMEDMETADATAID3PERIOD_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.timestampDeltaMilliseconds(), TIMESTAMPDELTAMILLISECONDS_BINDING);
            protocolMarshaller.marshall((Object)hlsGroupSettings.tsFileModeAsString(), TSFILEMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

