/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsCdnSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsCdnSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> HLSAKAMAISETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsAkamaiSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HLSBASICPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsBasicPutSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HLSMEDIASTORESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsMediaStoreSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HLSWEBDAVSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsWebdavSettings").isBinary(false).build();
    private static final HlsCdnSettingsMarshaller INSTANCE = new HlsCdnSettingsMarshaller();

    private HlsCdnSettingsMarshaller() {
    }

    public static HlsCdnSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsCdnSettings hlsCdnSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsCdnSettings, (String)"hlsCdnSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsCdnSettings.hlsAkamaiSettings(), HLSAKAMAISETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsCdnSettings.hlsBasicPutSettings(), HLSBASICPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsCdnSettings.hlsMediaStoreSettings(), HLSMEDIASTORESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsCdnSettings.hlsWebdavSettings(), HLSWEBDAVSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

