/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.GlobalConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GlobalConfigurationMarshaller {
    private static final MarshallingInfo<Integer> INITIALAUDIOGAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("initialAudioGain").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTENDACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputEndAction").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTLOSSBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputLossBehavior").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTTIMINGSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputTimingSource").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTLOWFRAMERATEINPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportLowFramerateInputs").isBinary(false).build();
    private static final GlobalConfigurationMarshaller INSTANCE = new GlobalConfigurationMarshaller();

    private GlobalConfigurationMarshaller() {
    }

    public static GlobalConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlobalConfiguration globalConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)globalConfiguration, (String)"globalConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)globalConfiguration.initialAudioGain(), INITIALAUDIOGAIN_BINDING);
            protocolMarshaller.marshall((Object)globalConfiguration.inputEndActionAsString(), INPUTENDACTION_BINDING);
            protocolMarshaller.marshall((Object)globalConfiguration.inputLossBehavior(), INPUTLOSSBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)globalConfiguration.outputTimingSourceAsString(), OUTPUTTIMINGSOURCE_BINDING);
            protocolMarshaller.marshall((Object)globalConfiguration.supportLowFramerateInputsAsString(), SUPPORTLOWFRAMERATEINPUTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

