/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.FecOutputSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FecOutputSettingsMarshaller {
    private static final MarshallingInfo<Integer> COLUMNDEPTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("columnDepth").isBinary(false).build();
    private static final MarshallingInfo<String> INCLUDEFEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("includeFec").isBinary(false).build();
    private static final MarshallingInfo<Integer> ROWLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rowLength").isBinary(false).build();
    private static final FecOutputSettingsMarshaller INSTANCE = new FecOutputSettingsMarshaller();

    private FecOutputSettingsMarshaller() {
    }

    public static FecOutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FecOutputSettings fecOutputSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)fecOutputSettings, (String)"fecOutputSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)fecOutputSettings.columnDepth(), COLUMNDEPTH_BINDING);
            protocolMarshaller.marshall((Object)fecOutputSettings.includeFecAsString(), INCLUDEFEC_BINDING);
            protocolMarshaller.marshall((Object)fecOutputSettings.rowLength(), ROWLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

