/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.EmbeddedSourceSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EmbeddedSourceSettingsMarshaller {
    private static final MarshallingInfo<String> CONVERT608TO708_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("convert608To708").isBinary(false).build();
    private static final MarshallingInfo<String> SCTE20DETECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte20Detection").isBinary(false).build();
    private static final MarshallingInfo<Integer> SOURCE608CHANNELNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source608ChannelNumber").isBinary(false).build();
    private static final MarshallingInfo<Integer> SOURCE608TRACKNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source608TrackNumber").isBinary(false).build();
    private static final EmbeddedSourceSettingsMarshaller INSTANCE = new EmbeddedSourceSettingsMarshaller();

    private EmbeddedSourceSettingsMarshaller() {
    }

    public static EmbeddedSourceSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EmbeddedSourceSettings embeddedSourceSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)embeddedSourceSettings, (String)"embeddedSourceSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)embeddedSourceSettings.convert608To708AsString(), CONVERT608TO708_BINDING);
            protocolMarshaller.marshall((Object)embeddedSourceSettings.scte20DetectionAsString(), SCTE20DETECTION_BINDING);
            protocolMarshaller.marshall((Object)embeddedSourceSettings.source608ChannelNumber(), SOURCE608CHANNELNUMBER_BINDING);
            protocolMarshaller.marshall((Object)embeddedSourceSettings.source608TrackNumber(), SOURCE608TRACKNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

