/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.Channel;
import software.amazon.awssdk.services.medialive.transform.ChannelEgressEndpointUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.EncoderSettingsUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.InputAttachmentUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.OutputDestinationUnmarshaller;

public class ChannelUnmarshaller
implements Unmarshaller<Channel, JsonUnmarshallerContext> {
    private static final ChannelUnmarshaller INSTANCE = new ChannelUnmarshaller();

    public Channel unmarshall(JsonUnmarshallerContext context) throws Exception {
        Channel.Builder channelBuilder = Channel.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    channelBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("destinations", targetDepth)) {
                    context.nextToken();
                    channelBuilder.destinations(new ListUnmarshaller((Unmarshaller)OutputDestinationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("egressEndpoints", targetDepth)) {
                    context.nextToken();
                    channelBuilder.egressEndpoints(new ListUnmarshaller((Unmarshaller)ChannelEgressEndpointUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("encoderSettings", targetDepth)) {
                    context.nextToken();
                    channelBuilder.encoderSettings(EncoderSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    channelBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("inputAttachments", targetDepth)) {
                    context.nextToken();
                    channelBuilder.inputAttachments(new ListUnmarshaller((Unmarshaller)InputAttachmentUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    channelBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("pipelinesRunningCount", targetDepth)) {
                    context.nextToken();
                    channelBuilder.pipelinesRunningCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    channelBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    channelBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Channel)channelBuilder.build();
    }

    public static ChannelUnmarshaller getInstance() {
        return INSTANCE;
    }
}

