/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.ChannelSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ChannelSummaryMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<List> DESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinations").isBinary(false).build();
    private static final MarshallingInfo<List> EGRESSENDPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("egressEndpoints").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<List> INPUTATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputAttachments").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Integer> PIPELINESRUNNINGCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelinesRunningCount").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();
    private static final ChannelSummaryMarshaller INSTANCE = new ChannelSummaryMarshaller();

    private ChannelSummaryMarshaller() {
    }

    public static ChannelSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ChannelSummary channelSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)channelSummary, (String)"channelSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)channelSummary.arn(), ARN_BINDING);
            protocolMarshaller.marshall(channelSummary.destinations(), DESTINATIONS_BINDING);
            protocolMarshaller.marshall(channelSummary.egressEndpoints(), EGRESSENDPOINTS_BINDING);
            protocolMarshaller.marshall((Object)channelSummary.id(), ID_BINDING);
            protocolMarshaller.marshall(channelSummary.inputAttachments(), INPUTATTACHMENTS_BINDING);
            protocolMarshaller.marshall((Object)channelSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)channelSummary.pipelinesRunningCount(), PIPELINESRUNNINGCOUNT_BINDING);
            protocolMarshaller.marshall((Object)channelSummary.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)channelSummary.stateAsString(), STATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

