/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.BlackoutSlate;
import software.amazon.awssdk.services.medialive.transform.InputLocationUnmarshaller;

public class BlackoutSlateUnmarshaller
implements Unmarshaller<BlackoutSlate, JsonUnmarshallerContext> {
    private static final BlackoutSlateUnmarshaller INSTANCE = new BlackoutSlateUnmarshaller();

    public BlackoutSlate unmarshall(JsonUnmarshallerContext context) throws Exception {
        BlackoutSlate.Builder blackoutSlateBuilder = BlackoutSlate.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("blackoutSlateImage", targetDepth)) {
                    context.nextToken();
                    blackoutSlateBuilder.blackoutSlateImage(InputLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("networkEndBlackout", targetDepth)) {
                    context.nextToken();
                    blackoutSlateBuilder.networkEndBlackout((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("networkEndBlackoutImage", targetDepth)) {
                    context.nextToken();
                    blackoutSlateBuilder.networkEndBlackoutImage(InputLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("networkId", targetDepth)) {
                    context.nextToken();
                    blackoutSlateBuilder.networkId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    blackoutSlateBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BlackoutSlate)blackoutSlateBuilder.build();
    }

    public static BlackoutSlateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

