/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioSelectorSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioSelectorSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUDIOLANGUAGESELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioLanguageSelection").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AUDIOPIDSELECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioPidSelection").isBinary(false).build();
    private static final AudioSelectorSettingsMarshaller INSTANCE = new AudioSelectorSettingsMarshaller();

    private AudioSelectorSettingsMarshaller() {
    }

    public static AudioSelectorSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioSelectorSettings audioSelectorSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)audioSelectorSettings, (String)"audioSelectorSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)audioSelectorSettings.audioLanguageSelection(), AUDIOLANGUAGESELECTION_BINDING);
            protocolMarshaller.marshall((Object)audioSelectorSettings.audioPidSelection(), AUDIOPIDSELECTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

